//Never code working properly for changing addresses of Lidar units 
//Refresh range and velocity functions work well

#include "LidarLite.h"
#include "mbed.h"

LidarLite::LidarLite(PinName sda, PinName scl): i2c_(sda, scl), debug(USBTX,USBRX){
    
    curr_address = LIDAR_LITE_DEFAULT_ADR<<1;
    
    i2c_.frequency(50000); //I2C @ 100kHz
    wait(0.5);
    //configure(int = 0, char = 0x62);
}

char LidarLite::address(){
    return curr_address>>1;
}
/* =============================================================================
  Configure
  Sets the configuration for the sensor, typically this is done in the begin()
  command, but sometimes (especially for multi-sensor applications) you will
  need to do this separately.
  Parameters
  ------------------------------------------------------------------------------
  - configuration: set the configuration for the sensor
    - default or 0 = equivelent to writing 0x00 to 0x00, i.e. full reset of
      sensor, if you write nothing for configuration or 0, the sensor will init-
      iate normally
    - 1 = high speed setting, set the aquisition count to 1/3 the default (works
      great for stronger singles) can be a little noisier
============================================================================= */
void LidarLite::configure(int configuration){
  uint8_t nackack = 1;
  switch (configuration){
    case 0: //  Default configuration
        nackack=i2c_.write(curr_address);        //device address with write condition
        if(nackack != 1)break;                       //No Ack, return False
        nackack=i2c_.write(0x00);                       //device ram address where obj value is present
        if(nackack != 1)break;                       //No Ack, return False
        //ack=i2c_.write(curr_address|0x00);   //device address with write condition (read is 0x01)
        //if(!ack)return false;                       //No Ack, return False
        i2c_.write(0x00);                              
    break;
    /*
    case 1: //  Set aquisition count to 1/3 default value, faster reads, slightly
            //  noisier values
      write(0x04,0x00,curr_address);
    break;
    case 2: //  Low noise, low sensitivity: Pulls decision criteria higher
            //  above the noise, allows fewer false detections, reduces
            //  sensitivity
      write(0x1c,0x20,curr_address);
    break;
    case 3: //  High noise, high sensitivity: Pulls decision criteria into the
            //  noise, allows more false detections, increses sensitivity
      write(0x1c,0x60,curr_address);
    break;
    */
  }
}



/* =============================================================================
  Change I2C Address for Single Sensor
  There are only certain address that will work with LIDAR-Lite so be sure to
  review the "Notes" section below
  Process
  ------------------------------------------------------------------------------
  1.  Read the two byte serial number from control_reg[0x16 using auto-increment
  2.  Write the high byte of the serial number to control_reg[0x18]
  3.  Write the low byte of the serial number to control_reg[0x19]
  4.  Write the new address you want to use to control_reg[0x1a]
  5.  Write 0x08 to control_reg[0x1E]
  Parameters
  ------------------------------------------------------------------------------
  - new_address: the hex value of the I2C address you want the sensor to have
  Notes
  ------------------------------------------------------------------------------
    Possible Address for LIDAR-Lite
    7-bit address in binary form need to end in "0". Example: 0x62 = 01100010 so
    that works well for us. Essentially any even numbered hex value will work
    for 7-bit address.
  =========================================================================== */
bool LidarLite::changeAddress(char new_address){
    if(new_address & 0x01) {
        debug.printf("New address must be an even number\r\n"); 
        return false;
        }
    if(new_address & 0x80) {
        debug.printf("New address must be a 7-bit number\r\n");
        return false;
    }
    
    // read control registers 0x16 and 0x17 using auto-increment to get the full Serial Number
    char serial_number[2];
    bool success = read(0x16, serial_number, 2, true);
    if(success){
        
        //  Write the upper byte of the serial number to control_reg[0x18]
        char write_buf[2] = {0x18, serial_number[0]};
        success = write(write_buf, 2);
        if(success){
            
            //  Write the lower byte of the serial number to control_reg[0x19]
            write_buf[0] = 0x19;
            write_buf[1] = serial_number[1];
            success = write(write_buf,2);
            if(success){
                
                // Write new address to control_reg[0x1A]
                write_buf[0] = 0x1A;
                write_buf[1] = new_address;
                success = write(write_buf,2);
                if(success){
                    
                    // Write control_reg[0x1E] to enable the new address and disable the old address
                    write_buf[0] = 0x1E;
                    write_buf[1] = 0x08;
                    success = write(write_buf,2);
                    curr_address = (new_address<<1);
                    return success;
                }
            }
        }
    }
    // if a 'write' or 'read' fails, then return 'false'
    return false;
}

bool LidarLite::write(char* buffer, int length){
    //if(auto_increment) buffer[0] = buffer[0] | 0x80;
    
    int nack = i2c_.write(curr_address, buffer, length);
    wait_ms(1);
    if(nack) return false;
    else return true;
}

bool LidarLite::read(char control_reg, char* buffer, int length, bool auto_increment = false){
    if(auto_increment) control_reg = control_reg | 0x80;
    
    int nack=1;
    while(nack){
        nack = i2c_.write(curr_address, &control_reg, 1);
        wait_ms(1);
    }
    if(nack) return false;
    
    nack=1;
    while(nack){
        nack = i2c_.read(curr_address, buffer, length);
        wait_ms(1);
    }
    if(nack) return false;
    
    return true;
}



//Refresh Range for returning distance
int32_t LidarLite::getDistance()
{
    bool success = write((char*)start_acquisition, 2);
    if(success){
        char dist[2];
        success = read(GET_DistanceHBReg, dist, 2, true);
        if(success) return ((uint16_t)dist[0] << 8) + (uint16_t)dist[1];
    }
    return -1;
}



//Refreshes velocity for return velocity
int16_t LidarLite::getVelocity()
{
    /*
    // Commands
#define SET_CommandReg       0x00   // Register to write to initiate ranging
#define AcqMode              0x04   // Value to set in control register to initiate ranging

    uint8_t nackack;
    char write[2]={SET_CommandReg, AcqMode};
    char vel;
    
    nackack=1;
    while(nackack !=0)
    {
        wait_ms(1);
        nackack = i2c_.write(curr_address, write, 2);
    }
    
    nackack=1;
    while(nackack !=0)
    {
        wait_ms(1);
        nackack = i2c_.write(curr_address, &GET_VelocityReg, 1);
    }    
    
    nackack=1;
    while(nackack !=0)
    {
        wait_ms(1);
        nackack = i2c_.read(curr_address, &vel, 1);
    }
    velocity_LL = (uint16_t)vel;
    
    if(velocity_LL < 127)
        return(velocity_LL*10);
    else
        return((velocity_LL-256)*10);
        */
}