 
#ifndef LidarLite_H
#define LidarLite_H 
 
#include "mbed.h"

// Default I2C Address of LIDAR-Lite.
#define LIDAR_LITE_DEFAULT_ADR 0x62



// Read Registers
const char start_acquisition[2] = {0x00, 0x04}; // write 0x04 to control_reg[0x00] to initiate ranging
const char GET_DistanceHBReg = 0x0f;   // High byte of distance reading data
const char GET_DistanceLBReg = 0x10;   // Low byte of distance reading data
const char GET_VelocityReg =   0x09;   // Velocity measurement data

class LidarLite
{
    public:
        LidarLite(PinName sda, PinName scl);    //Constructor
        char address();
        int16_t getVelocity();              //refreshes velocity data from registers of sensor
        int32_t getDistance();                 //refreshes range data from registers of sensor
        void configure(int);
        bool changeAddress(char);
        
    private:
        bool read(char, char*, int, bool);
        bool write(char*, int);
        
        I2C i2c_;
        Serial debug;
        char curr_address;
};

#endif /* LidarLite_H */