#include <string.h>
#include "mbed.h"
#include "BLEDevice.h"

#include "UARTService.h"

#define DEBUG 1

#if DEBUG
#define LOG_BUFFER 100
#define LOG(...)  do { if (uart) {snprintf(debugBuffer, LOG_BUFFER , __VA_ARGS__); uart->write(debugBuffer, strlen(debugBuffer));} } while (0)
#else
#define LOG_BUFFER 0
#define LOG(...) /* nothing */
#endif /* #if DEBUG */


char debugBuffer[LOG_BUFFER];
BLEDevice  ble;
UARTService *uart;

PinName pins[] = {P0_0, P0_1, P0_2,P0_3,P0_4,P0_5,P0_6,P0_7,P0_8,P0_9,P0_10,
P0_11,P0_12,P0_13,P0_14,P0_15,P0_16,P0_17,P0_18,P0_19,P0_20,
P0_21,P0_22,P0_23,P0_24,P0_25,P0_26,P0_27,P0_28,P0_29,P0_30};

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    LOG("Disconnected!\n\r");
    LOG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

void testPins(){
        for (int i =0;i<=30;i++){
            for (int j=i+1;j<=30;j++){
                DigitalOut output(pins[i]);
                DigitalIn inup(pins[j],PullUp);
                output=0;
                if (inup==0){
                   output=1;
                   if (inup==1){
                        LOG("Check pin %d & %d (PullUp)\n\r",i,j);
                    } 
                }
                DigitalIn indown(pins[j],PullDown);
                output=1;
                if (indown==1){
                   output=0;
                   if (indown==0){
                        LOG("Check pin %d & %d (PullDown)\n\r",i,j);
                    } 
                }                                    
            }
        }
}

void periodicCallback(void)
{
    LOG("Testing...\r\n");
    testPins();    
    LOG("Done!!!\r\n");
}



int main() {
    Ticker ticker;
    ticker.attach(periodicCallback, 5);

    LOG("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    
    uart = new UARTService(ble);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"BLE UART", sizeof("BLE UART") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    while (true) {
        ble.waitForEvent();
    }
}
