/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <string.h>
#include <stdarg.h>
#include "mbed.h"


#define DEBUG 1 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

//Icarus libraries
#include "ADXL362Sensor.h"
#include "MPU9250Sensor.h"



#define BAUD_RATE 115200
Serial s(P0_5, P0_6);

#if DEBUG
#define LOG_BUFFER 100
#define LOG(...)  do { if (debug) { debug( __VA_ARGS__); } } while (0)
#else
#define LOG_BUFFER 0
#define LOG(...) /* nothing */
#endif /* #if DEBUG */
char debugBuffer[LOG_BUFFER];
void debug ( const char* format, ...) {
    va_list argptr;
    va_start(argptr, format);
//    vsnprintf(debugBuffer, LOG_BUFFER ,format, argptr);
    vprintf(format, argptr);
    va_end(argptr);  
//    if (uart){
//        uart->write(debugBuffer, strlen(debugBuffer));
//    }
}



SPI spi1(P0_28, P0_24, P0_29); // mosi, miso, sclk
DigitalOut adxl_cs(P0_23);
DigitalOut mpu_cs(P0_18);

DigitalOut led(P0_5); 
DigitalOut motor(P0_6); 

DigitalIn button(P0_16,PullDown);



uint32_t sensorErrors[10];


ADXL362Sensor adxl362(spi1, adxl_cs, debug);
MPU9250Sensor mpu9250(spi1, mpu_cs, debug);




int testSensors(BaseSensor& sensor)
{
    uint32_t errorCount = sensor.verifyIntegrity(sensorErrors);
    if (errorCount>0){
        for (int i=0;i<errorCount;i++){
            LOG("ERROR: Sensor %s failed with error code: %d\n\r",sensor.getSimpleName(),sensorErrors[i]);
        }
    } else {
        LOG("Sensor %s validated!\n\r",sensor.getSimpleName());     
    }
    return errorCount;   
}



int main(void)
{
    s.baud(BAUD_RATE);
    

    LOG("Initialising the nRF51822\n\r");

    while (true) {
        testSensors(adxl362);
//        testSensors(mpu9250);
        wait(10.0f);
    }
}