#ifndef MBED_ADXL362_SENSOR_H
#define MBED_ADXL362_SENSOR_H
 
#include "mbed.h"

#include "BaseSensor.h"

// ACC Registers
#define ADXL362_DEVID_AD 0x00
#define ADXL362_DEVID_MST 0x01
#define ADXL362_PART_ID 0x02
#define ADXL362_REV_ID 0x03

//Three following addresses
#define ADXL362_DATA 0x08

#define ADXL362_STATUS 0x0b
#define ADXL362_FIFO_ENTRIES_L 0x0c
#define ADXL362_FIFO_ENTRIES_H 0x0d

//Six following address as L & H
#define ADXL362_DATA_12 0x0E

//Two following bytes
#define ADXL362_TEMP_12 0x14


#define ADXL362_SOFT_RESET 0x1f
#define ADXL362_THRESH_ACT_11 0x20
#define ADXL362_TIME_ACT 0x22
#define ADXL362_THRESH_INACT_11 0x20
#define ADXL362_TIME_INACT_16 0x22
#define ADXL362_ACT_INACT_CTL 0x27
#define ADXL362_FIFO_CONTROL 0x28
#define ADXL362_FIFO_SAMPLES 0x29
#define ADXL362_INTMAP1 0x2a
#define ADXL362_INTMAP2 0x2b
#define ADXL362_FILTER_CTL 0x2c
#define ADXL362_POWER_CTL 0x2d
#define ADXL362_SELF_TEST 0x2e
 
/**The ADXL362 command set is
• 0x0A: write register
• 0x0B: read register
• 0x0D: read FIFO
*/ 
#define ADXL362_WRITE_REGISTER 0x0a
#define ADXL362_READ_REGISTER 0x0b
#define ADXL362_READ_FIFO 0x0d

#define ADXL362_SELF_TEST_SCALE_FACTOR 2.4f
#define ADXL362_MG2G_MULTIPLIER 0.002f
#define ADXL362_ODR 100.0f

 
class ADXL362Sensor : public BaseSensor {

public:
//The recommended SPI clock speeds are 1 MHz to 5 MHz, with 12 pF maximum loading.
    ADXL362Sensor(SPI&,DigitalOut&, void (*debug_)(const char* format, ...)=0);
    virtual char* getSimpleName();
    virtual void getSensorDetails(sensor_t*);
    //verify basic integrity of underlining hardware
    virtual uint32_t verifyIntegrity(uint32_t*);  
private:      
    SPI& spi; 
    DigitalOut& cs;
    
    uint32_t selfTest(uint32_t* errorResult);
    void refreshAcceleration12(int16_t* x, int16_t* y, int16_t* z);
    uint32_t readRegister32(uint8_t reg);
    uint8_t readRegister( uint8_t reg);
    void writeRegister( uint8_t reg, uint8_t cmd );
    
};
 
#endif