#include "mbed.h"

#define BAUD_RATE 9600 //default baud rate

InterruptIn button(p1);
DigitalOut led(LED1);
Timer debounce;                //define debundance timer
Timer timer1;                   //define timer variable
unsigned int counter=0;
unsigned int revMin=0;
float currentSpeed=0;
unsigned int currentTime = 0;       
const float wheelDiameter=0.662;    //662mm rim + 2*20mm tire put in meters

void toggle(void);          //function prototype

int main() {
    //Configure boud rate 
    Serial s(USBTX, USBRX); //default for nrf51 is p0.09 p0.11
    s.baud(BAUD_RATE);
   
    timer1.start();
    debounce.start();
    button.rise(&toggle);   // attach the addressof the toggle function to the rising edge
}

void toggle() {
if (debounce.read_ms()>100) //only allow toggle if debounce timer has passed 200ms
    led=!led;        
 
    debounce.reset();       //restart timer when toggle is performed
    currentTime=timer1.read_ms();
    revMin = (60*1000)/currentTime;
    currentSpeed = ((3.14159*wheelDiameter*1000)/(currentTime))*3.6;            //km.h
    timer1.reset();    
    counter = counter + 1;
    printf("id %i",counter);
    printf(" - time: %i",currentTime);
    printf(" - revs/min: %i",revMin);
    printf(" - speed: %4.2f",currentSpeed);
    printf(" km/h \n");
    //printf("switch \n\r");    
}
