#include "mbed.h"

SPI spi(P0_28, P0_24, P0_29); // mosi, miso, sclk
DigitalOut cs(P0_25); //bar1


// ACC Registers
#define MS5611_PROM 0xA0
#define MS5611_RESET 0x1E


//Test that spi is working with fram MS5611 memory
//mosi: || 0x1E || 0xA0 0x00 0x00 || 0xA2 0x00 0x00 || ... || 0xAE 0x00 0x00 ||
//miso: || 0x00 || 0x00 0x?? 0x?? || 0x00 0x?? 0x?? || ... || 0x00 0x?? 0x?? ||

void reset(){
    cs=0;
    spi.write(MS5611_RESET);
    wait_ms(3);
    cs=1;
}

void readProm(int rec){
    cs=0;
        spi.write(MS5611_PROM+rec);
        uint8_t factory_data = spi.write(0x00);
        uint8_t setup = spi.write(0x00);
        cs=1;
}

int main() {
    cs=1;
    while(1) {
        reset();
        for(int i=0;i<16;i+=2){
        readProm(i);
        wait(0.2); 
        }
        wait(0.5);
    }
}

