#include "mbed.h"

SPI spi(P0_2, P0_3, P0_4); // mosi, miso, sclk
DigitalOut cs(P0_30);
DigitalOut hold(P0_1);


// ACC Registers
#define FM25CL_WREN 0x06
#define FM25CL_WRDI 0x04
#define FM25CL_RDSR 0x05
#define FM25CL_WRSR 0x01
#define FM25CL_READ 0x03
#define FM25CL_WRITE 0x02

#define TEST_LENGTH 4

void readRegister(){
    cs = 0;        
    spi.write(FM25CL_RDSR);
    //should be 0x00
    uint8_t val_register = spi.write(0x00);
    cs = 1;
}
void sendCommand(uint8_t reg){
    cs = 0;        
    spi.write(reg);
    cs = 1;
}

//Test that spi is working with fram FM25CL memory
//mosi: || 0x05 0x00 || 0x06 || 0x05 0x00 || 0x06 || 
//miso: || 0x00 0x00 || 0x00 || 0x00 0x02 || 0x00 ||
int main() {
    hold=1;
    cs=1;
    while(1) {
        readRegister();
        sendCommand(FM25CL_WREN);
        readRegister();
        sendCommand(FM25CL_WRDI);
        wait(0.5); 
    }
}

