#ifndef PQES920LR_H
#define PQES920LR_H

/**
 * ES920LRのライブラリ
 * @note 内部でシリアル受信割り込みを使用しています
 * @note 適切な送信時間間隔を取ること
 * @note attachで受信イベントハンドラを設定すること
 * @code
#include "mbed.h"
#include "PQES920LR.h"

Serial pc(USBTX, USBRX, 115200);
Serial es_serial(p9, p10, 115200);

ES920LR es(es_serial);

char data[50];

void on_receive(char *buff)
{
    for(int i = 0; i < 50; i++) {
        pc.printf("%x ", buff[i]);
    }
}

int main()
{
    es.attach(&on_receive);
    for(int i = 0; i < 50; i++) {
        data[i] = 0xFF;
    }
    while(1) {
        es.send(data, 50);
        wait(1);
    }
}
 * @endcode
 */

class ES920LR
{
private:
    Serial *_serial;
    char tx_buf[52];
    char rx_buf[52];
    char rx_size;
    int index;
    int flag;
    bool response;

    void (*func)(char*);

public:
    /**
     * @param es_serial Serialのインスタンスへの参照
     */
    ES920LR(Serial &es_serial);

    /**
     * @param data 送信するバイナリデータの配列（最大50バイト）
     * @param size 送信するバイナリデータのサイズ
     */
    void send(char *data, int size);

    /**
     * @param func_ptr 受信時に呼ばれる関数へのポインタ、引数に受信データを受け取る
     */
    void attach(void(*func_ptr)(char*));

private:
    void receive();
};

#endif