#ifndef PQEEPROM_H_
#define PQEEPROM_H_

/**
 * EEPROM 24FC1025のライブラリ
 * @note 1つにつき0x000000~0x01FFFFまでのアドレスが指定できます
 * @note 2つ使用する場合は0x000000~0x03FFFFまでのアドレスが指定でき、最大4つ同時に使用できます
 * @note 1ページは128バイトです
 * @note ページをまたぐような書き込みは危険なのでしないこと
 * @note 受信バッファは128バイトです
 * @code
#include "mbed.h"
#include "PQEEPROM.h"

Serial pc(USBTX, USBRX, 115200);

I2C i2c(p9, p10);

EEPROM eeprom(i2c);

int addr;
char data[128];
char buff[128];

int main()
{
    addr = 0x000000;
    for(int i = 0; i < 128; i++) {
        data[i] = 0xFF;
    }
    eeprom.write(addr, data, 128);
    eeprom.read(addr, buff, 128);
    for(int i = 0; i < 128; i++) {
        pc.printf("%x ", buff[i]);
    }
}
 * @endcode
 */
class EEPROM
{
private:
    I2C *_i2c;
    int _addr;
    char cmd[130];
    char buff[128];

public:
    /**
     * @param i2c I2Cのインスタンスへの参照
     */
    EEPROM(I2C &i2c);

    /**
     * 連続書き込み
     * @param addr 書き込みアドレス
     * @param data 書き込むデータの配列（最大128バイト）
     * @param size 書き込むデータのサイズ
     */
    void write(int addr, char *data, int size);

    /**
     * 連続読み込み
     * @param addr 読み込みアドレス
     * @param data 読み込むデータの配列（最大128バイト）
     * @param size 読み込むデータのサイズ
     */
    void read(int addr, char *data, int size);
};

#endif