#include "mbed.h"
#include "PQAEGPS.h"

AEGPS::AEGPS(Serial &gps_serial)
{
    _serial = &gps_serial;
    _serial->attach(callback(this, &AEGPS::receive), Serial::RxIrq);
}

void AEGPS::receive()
{
    char c = _serial->getc();
    if(c == '$') {
        index = 0;
        flag = 1;
    }
    if(flag == 1) {
        rx_buf[index] = c;
        if(c == '\n') {
            rx_buf[index + 1] = '\0';
            flag = 2;
        } else {
            index++;
        }
    }
    if(flag == 2) {
        sscanf(rx_buf, "$GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,M,%f,M", &sec, &lat, &ns, &lon, &ew, &fix, &sat, &hdop, &alt, &geoid);

        hour = (int)(sec / 10000);
        min = (int)(sec - hour * 10000) / 100;
        sec = sec - hour * 10000 - min * 100;

        int d;
        float m;

        d = (int)lat / 100;
        m = lat - (float)d * 100;
        lat = (float)d + m / 60;
        if(ns == 'S') {
            lat = -lat;
        }

        d = (int)lon / 100;
        m = lon - (float)d * 100;
        lon = (float)d + m / 60;
        if(ns == 'W') {
            lon = -lon;
        }

        flag = 0;
    }
}

int AEGPS::get_hour()
{
    return hour;
}

int AEGPS::get_min()
{
    return min;
}

float AEGPS::get_sec()
{
    return sec;
}

float AEGPS::get_lat()
{
    return lat;
}

float AEGPS::get_lon()
{
    return lon;
}

int AEGPS::get_fix()
{
    return fix;
}

int AEGPS::get_sat()
{
    return sat;
}

float AEGPS::get_hdop()
{
    return hdop;
}

float AEGPS::get_alt()
{
    return alt;
}

float AEGPS::get_geoid()
{
    return geoid;
}