#ifndef PQAEGPS_H
#define PQAEGPS_H

/**
 * AE-GPSのライブラリ
 * @note 内部でシリアル受信割り込みを使用しています
 * @note GPGGAフォーマットのみを出力するように設定し、バックアップ用電池を使用すること
 * @code
#include "mbed.h"
#include "PQAEGPS.h"

Serial pc(USBTX, USBRX, 115200);
Serial gps_serial(p9, p10, 115200);

AEGPS gps(gps_serial);

int main()
{
    while(1) {
        pc.printf("lat:%.6f, lon:%.6f, time:%d:%d:%.1f, fix:%d, sat:%d, hdop:%.2f, alt:%.1f, geoid:%.1f\r\n", gps.get_lat(), gps.get_lon(), gps.get_hour(), gps.get_min(), gps.get_sec(), gps.get_fix(), gps.get_sat(), gps.get_sat(), gps.get_hdop(), gps.get_alt(), gps.get_geoid());
    }
}
 * @endcode
 */
class AEGPS
{
private:
    Serial *_serial;
    char rx_buf[256];
    int index;
    int flag;
    int hour;
    int min;
    float sec;
    float lat;
    char ns;
    float lon;
    char ew;
    int fix;
    int sat;
    float hdop;
    float alt;
    float geoid;

public:
    /**
     * @param &gps_serial Serialのインスタンスへの参照
     */
    AEGPS(Serial &gps_serial);

private:
    void receive();

public:
    /**
     * 協定世界時（UTC）の時間のゲッター
     * @return 時間（UTC)
     */
    int get_hour();

    /**
     * 協定世界時（UTC）の分のゲッター
     * @return 分（UTC)
     */
    int get_min();

    /**
     * 協定世界時（UTC）の秒のゲッター
     * @return 秒（UTC)
     */
    float get_sec();

    /**
     * 緯度のゲッター
     * @return 緯度
     */
    float get_lat();

    /**
     * 経度のゲッター
     * @return 経度
     */
    float get_lon();

    /**
     * 位置特定品質のゲッター
     * @return 位置特定品質
     */
    int get_fix();

    /**
     * 使用衛星数のゲッター
     * @return 使用衛星数
     */
    int get_sat();

    /**
     * 水平精度低下率のゲッター
     * @return 水平精度低下率
     */
    float get_hdop();

    /**
     * 海抜高さのゲッター
     * @return 海抜高さ
     */
    float get_alt();

    /**
     * ジオイド高さのゲッター
     * @return ジオイド高さ
     */
    float get_geoid();
};

#endif