#include "mbed.h"

#include "SDFileSystem.h"

#include "Adafruit_ADS1015.h"

#define ADS1115_ADDR 0b1001000

#define TEMP_LSB 0.0625f

Serial pc(USBTX, USBRX, 115200);

Serial wireless(p28,p27);

I2C i2c(p9, p10);

Adafruit_ADS1115 ads1115(&i2c, ADS1115_ADDR);

SDFileSystem sd(p5, p6, p7, p8, "sd");

const int Threshold = 3580;

DigitalInOut valve_controler1(p18, PIN_OUTPUT, OpenDrain, 0);
DigitalInOut valve_controler2(p19, PIN_OUTPUT, OpenDrain, 0);

bool IsValveOpened = false;

bool APLFlug = true; 

DigitalOut led1(LED1);

Timer timer;
Timer sd_timer;

FILE *fp;

char file_name[64];

int press_bit1, press_bit2;

bool ConfigFlag = false; 

void ValveOpen()
{
	valve_controler1 = 1;
	valve_controler2 = 1;
	IsValveOpened = true;
}

void ValveClose()
{
	valve_controler1 = 0;
	valve_controler2 = 0;
	IsValveOpened = false;
}

int main()
{
	timer.start();
	wireless.baud(115200);

	uint16_t data[2];
	ads1115.setGain(GAIN_TWOTHIRDS);

	char file_name_format[] = "/sd/IZU2021_VALVE_MEASUREMENT_%d.dat";
	int file_number = 1;
	while(1) {
		sprintf(file_name, file_name_format, file_number);
		fp = fopen(file_name, "r");
		if(fp != NULL) {
			fclose(fp);
			file_number++;
		} else {
			sprintf(file_name, file_name_format, file_number);
			break;
		}
	}
	fp = fopen(file_name, "w");
	sd_timer.start();

	int dt = 0;
	while(1) {

		press_bit1 = ads1115.readADC_SingleEnded(1);
		press_bit2 = ads1115.readADC_SingleEnded(3);

		// Debug and Config section-----------------------------------------------------------------
		if (pc.readable() > 0)
		{
			wireless.putc(pc.getc());
			if(!ConfigFlag)
			{
				ConfigFlag = true;
			}
		}
		if(ConfigFlag)
		{
			while (wireless.readable() > 0)
			{
				pc.putc(wireless.getc());
			}
			continue;
		}
		// -----------------------------------------------------------------------------------------

		int time = timer.read_ms();
		if(time - dt >= 5000)
		{
			// Debug and Config section-----------------------------------------------------------------
			if (pc.readable() == 0 && wireless.readable() == 0)
			{
				pc.printf("%d\t%d\t%d\r\n", timer.read_ms(), press_bit1, press_bit2);
			}
			// -----------------------------------------------------------------------------------------

			wireless.printf("Tank %d APL %s Valve %s.\r\n", press_bit1, APLFlug ? "on":"off" , IsValveOpened ? "open":"close" );
			dt = time;
		}
		//valvcontroler auto pressure limitation----------------------------------------------------
		if(wireless.readable() > 0)
		{
			// This support only single lettar.
			char up_msg = wireless.getc();

			//wireless.printf("Message = %c.",up_msg);

			if (up_msg == 'o') //open
			{
				ValveOpen();
				APLFlug = false;
			}
			else if (up_msg == 'c') //close
			{
				ValveClose();
				APLFlug = false;
			}
			else 
			{
				if (// These must be just responses.
							   up_msg != 'O' 
							&& up_msg != 'K'
							&& up_msg != 'N'
							&& up_msg != 'G'
							&& up_msg != ' '
							&& up_msg != '0'
							&& up_msg != '1'
							&& up_msg != '2'
							&& up_msg != '3'
							&& up_msg != '4'
							&& up_msg != '5'
							&& up_msg != '6'
							&& up_msg != '7'
							&& up_msg != '8'
							&& up_msg != '9'
							&& up_msg != '\0'
							&& up_msg != '\r'
							&& up_msg != '\n'
				     ){
					wireless.printf("You send invaild command.\r\n");
				}
			}
		}
		if(APLFlug)
		{
			if(press_bit1 > Threshold)
			{
				ValveOpen();
			}
			else{
				ValveClose();
			}
		}
		//------------------------------------------------------------------------------------------
		fprintf(fp, "%d,%d,%d\r\n", time, press_bit1, press_bit2);

		if(sd_timer.read_ms() > 20*1000) {
			if(fp) {
				fclose(fp);
				fp = fopen(file_name, "a");
			}
		}
	}
}
// If you feel this ugly, please refactor THIS !!.
