#include "mbed.h"

#include "PQEEPROM.h"

Serial pc(USBTX, USBRX, 115200);

I2C i2c(p28, p27);

EEPROM eeprom(i2c);

char data[128];

char mission_timer_reset;
int mission_time;
int flight_time;
char f_sd;
char f_gps;
char f_adxl;
char f_ina_in;
char f_ina_ex;
char f_lps;
char f_mpu;
char f_mpu_ak;
char phase;
int utc_hour;
int utc_min;
float utc_sec;
float lat;
float lon;
int sat;
int fix;
float hdop;
float alt;
float geoid;
float high_accel[3];
float voltage_in;
float current_in;
float voltage_ex;
float current_ex;
float press;
float temp;
float accel[3];
float gyro[3];
float mag[3];

int main()
{
    for(int addr = 0x000000; addr < 0x07FFFF; addr += 0x80) {
        eeprom.read(addr, data, 128);
        mission_timer_reset = data[1];
        mission_time = *(int*)&data[2];
        flight_time = *(int*)&data[6];
        f_sd = data[10];
        f_gps = data[11];
        f_adxl = data[12];
        f_ina_in = data[13];
        f_ina_ex = data[14];
        f_lps = data[15];
        f_mpu = data[16];
        f_mpu_ak = data[17];
        phase = data[18];
        lat = *(float*)&data[19];
        lon = *(float*)&data[23];
        sat = *(int*)&data[27];
        fix = *(int*)&data[31];
        hdop = *(float*)&data[35];
        alt = *(float*)&data[39];
        geoid = *(float*)&data[43];
        high_accel[0] = *(float*)&data[47];
        high_accel[1] = *(float*)&data[51];
        high_accel[2] = *(float*)&data[55];
        voltage_in = *(float*)&data[59];
        current_in = *(float*)&data[63];
        voltage_ex = *(float*)&data[67];
        current_ex = *(float*)&data[71];
        press = *(float*)&data[75];
        temp = *(float*)&data[79];
        accel[0] = *(float*)&data[83];
        accel[1] = *(float*)&data[87];
        accel[2] = *(float*)&data[91];
        gyro[0] = *(float*)&data[95];
        gyro[1] = *(float*)&data[99];
        gyro[2] = *(float*)&data[103];
        mag[0] = *(float*)&data[107];
        mag[1] = *(float*)&data[111];
        mag[2] = *(float*)&data[115];
        
        pc.printf("addr:%x", addr);
        pc.printf("mission_timer_reset: %d\r\n", mission_timer_reset);
        pc.printf("mission_time: %d\r\n", mission_time);
        pc.printf("flight_time: %d\r\n", flight_time);
        pc.printf("phase: %d\r\n", phase);
        pc.printf("f_sd: %d\r\n", f_sd);
        pc.printf("f_gps: %d\r\n", f_gps);
        pc.printf("f_adxl: %d\r\n", f_adxl);
        pc.printf("f_ina_in: %d\r\n", f_ina_in);
        pc.printf("f_ina_ex: %d\r\n", f_ina_ex);
        pc.printf("f_lps: %d\r\n", f_lps);
        pc.printf("f_mpu: %d\r\n", f_mpu);
        pc.printf("f_mpu_ak: %d\r\n", f_mpu_ak);
        pc.printf("lat: %f\r\n", lat);
        pc.printf("lon: %f\r\n", lon);
        pc.printf("sat: %d\r\n", sat);
        pc.printf("fix: %d\r\n", fix);
        pc.printf("hdop: %f\r\n", hdop);
        pc.printf("alt: %f\r\n", alt);
        pc.printf("geoid: %f\r\n", geoid);
        pc.printf("high_accel_x: %f\r\n", high_accel[0]);
        pc.printf("high_accel_y: %f\r\n", high_accel[1]);
        pc.printf("high_accel_z: %f\r\n", high_accel[2]);
        pc.printf("voltage_in: %f\r\n", voltage_in);
        pc.printf("current_in: %f\r\n", current_in);
        pc.printf("voltage_ex: %f\r\n", voltage_ex);
        pc.printf("current_ex: %f\r\n", current_ex);
        pc.printf("press: %f\r\n", press);
        pc.printf("temp: %f\r\n", temp);
        pc.printf("accel_x: %f\r\n", accel[0]);
        pc.printf("accel_y: %f\r\n", accel[1]);
        pc.printf("accel_z: %f\r\n", accel[2]);
        pc.printf("gyro_x: %f\r\n", gyro[0]);
        pc.printf("gyro_y: %f\r\n", gyro[1]);
        pc.printf("gyro_z: %f\r\n", gyro[2]);
        pc.printf("mag_x: %f\r\n", mag[0]);
        pc.printf("mag_y: %f\r\n", mag[1]);
        pc.printf("mag_z: %f\r\n", mag[2]);
    }
}
