#include "mbed.h"
#include "Adafruit_ADS1015.h"
#include "SDFileSystem.h"
#define ADS1115_ADDR 0b1001000

Serial pc(USBTX, USBRX, 115200);
I2C i2c(p28, p27);
Adafruit_ADS1115 ads1115(&i2c, ADS1115_ADDR);
SDFileSystem sd_file_system(p5, p6, p7, p8, "sd");
Timer sd_timer;

FILE *sd;
char file_name[64];
char f_sd;
int16_t val[4] = {};
float voltage[4] = {};
float sum[4] = {};
float v_ave[4] = {};
float strain_v[4] = {};

int main()
{
    ads1115.setGain(GAIN_TWOTHIRDS);

    char file_name_format[] = "/sd/IZU2020_MISSION_%d.dat";
    int file_number = 1;
    while(1) {
        sprintf(file_name, file_name_format, file_number);
        sd = fopen(file_name, "r");
        if(sd != NULL) {
            fclose(sd);
            file_number++;
        } else {
            sprintf(file_name, "/sd/IZU2020_MISSION_%d.dat", file_number);
            break;
        }
    }
    sd = fopen(file_name, "w");
    sd_timer.start();
    if(sd) {
        fprintf(sd, "f_sd, ");
        fprintf(sd, "speed[m/s],");
        fprintf(sd, "sigma1,");
        fprintf(sd, "sigma2,");
        fprintf(sd, "taumax[MPa],");
        fprintf(sd, "\r\n");
    }

    for(int i = 0; i < 10; i ++ ) {
        val[0] = ads1115.readADC_SingleEnded(0);
        val[1] = ads1115.readADC_SingleEnded(1);
        val[2] = ads1115.readADC_SingleEnded(2);
        val[3] = ads1115.readADC_SingleEnded(3);
        voltage[0] = val[0] / 32768.0 * 6.144;
        voltage[1] = val[1] / 32768.0 * 6.144;
        voltage[2] = val[2] / 32768.0 * 6.144;
        voltage[3] = val[3] / 32768.0 * 6.144;
        sum[0] += voltage[0];
        sum[1] += voltage[1];
        sum[2] += voltage[2];
        sum[3] += voltage[3];
    }
    v_ave[0] = sum[0] / 10.0;
    v_ave[1] = sum[1] / 10.0;
    v_ave[2] = sum[2] / 10.0;
    v_ave[3] = sum[3] / 10.0;

    while(1) {
        val[0] = ads1115.readADC_SingleEnded(0);
        val[1] = ads1115.readADC_SingleEnded(1);
        val[2] = ads1115.readADC_SingleEnded(2);
        val[3] = ads1115.readADC_SingleEnded(3);
        voltage[0] = val[0] / 32768.0 * 6.144;
        voltage[1] = val[1] / 32768.0 * 6.144;
        voltage[2] = val[2] / 32768.0 * 6.144;
        voltage[3] = val[3] / 32768.0 * 6.144;
        pc.printf("%d, r%d, g%d, w%d\r\n",  val[0], val[1], val[2], val[3]);
        pc.printf("%f, r%f, g%f, w%f [V]\r\n",  voltage[0], voltage[1], voltage[2], voltage[3]);

        /*pitot_tube
        -------------------------------------------------*/
        float pitot_v = voltage[0] - v_ave[0] + 1;
        //P = ((Vout / Vs) - 0.2) / 0.2
        float pitot_Pa = (pitot_v / 5.0 - 0.2) / 0.2;
        printf("pressure %f[kPa]\r\n", pitot_Pa);
        float density = 1.3;
        //v = root(2 * P / ρ)
        float pitot_speed = sqrt(2 * pitot_Pa * 1000 / density);
        printf("speed %f[m/s]\r\n", pitot_speed);
        printf("speed %f[km/h]\r\n", pitot_speed * 3600 / 1000.0);
        
        /*strain_gauge
        ----------------------------------------------------*/
        strain_v[1] = voltage[1] - v_ave[1];
        strain_v[2] = voltage[2] - v_ave[2];
        strain_v[3] = voltage[3] - v_ave[3];
        //VOUT – VREF = G(VIN+ – VIN–)
        //VREF = GND
        //G = (49.4kΩ/RG) + 1
        //straun = 2/3.3*V
        float G = (49.4 * 1000 / 120.0) + 1;
        float V1 = strain_v[1] / G;
        float strain1 = 2 / 3.3 * V1 * 1000000.0;
        float V2 = strain_v[2] / G;
        float strain2 = 2 / 3.3 * V2 * 1000000.0;
        float V3 = strain_v[3] / G;
        float strain3 = 2 / 3.3 * V3 * 1000000.0;
        printf("strain r %f g %f w %f [uε]\r\n", strain1, strain2, strain3);

        float E = 2.5;//Al 72GPa
        float nu = 0.3;//ポアソン比
        float g = E / 2 / (1 + nu); //横弾性係数
        float sigmax = E / (1 - nu * nu) * (strain1 + nu * strain3) / 1000.0;
        float sigmay = E / (1 - nu * nu) * (nu * strain1 + strain3) / 1000.0;
        float gammaxy = 2 * strain2 - strain1 - strain3;
        float tauxy = g * gammaxy / 1000.0;
        float sigma1 = (sigmax + sigmay) + sqrt((sigmax - sigmay) * (sigmax - sigmay) + 4 * tauxy * tauxy);
        float sigma2 = (sigmax + sigmay) - sqrt((sigmax - sigmay) * (sigmax - sigmay) + 4 * tauxy * tauxy);
        float taumax = (sigma1 - sigma2) / 2.0;
        printf("sigmax %f sigmay %f tauxy %f [MPa]\r\n", sigmax, sigmay, tauxy);
        printf("sigma1 %f sigma2 %f taumax %f [MPa]\r\n", sigma1, sigma2, taumax);
        
        /*sd
        --------------------------------------------------------*/
        f_sd = bool(sd);
        if(sd) {
            fprintf(sd, "%d,", f_sd);
            fprintf(sd, "%f,", pitot_speed);
            fprintf(sd, "%f,", sigma1);
            fprintf(sd, "%f,", sigma2);
            fprintf(sd, "%f,", taumax);
            fprintf(sd, "\r\n");
        }
        if(sd_timer.read_ms() >= 60*1000) {
            sd_timer.reset();
            sd_timer.start();
            if(sd) {
                fclose(sd);
                sd = fopen(file_name, "a");
            }
        }
        
        /*test
        ----------------------------------------------------*/
        float P = 5.0 * 9.8;
        float A = 14.5 * 3.0;
        float sigma = P / A;
        pc.printf("test %f\r\n", sigma);
        
        wait(0.5);
    }
}
