#include "buttons.h"

button::button(uint16_t x, uint16_t y, uint16_t w, uint16_t h,uint32_t colorOn,uint32_t colorOff)
{
     
     m_colorOn=colorOn;
     m_colorOff=colorOff;
     m_x=x;
     m_y=y;
     m_w=w;
     m_h=h;
     m_state=false;
     m_memoState=false;
     draw();
     BSP_TS_Init(480,272);
     m_touchRead.attach(this,&button::readState,0.2);
     
}

/* Changement d'état du bouton */
void button::draw(void)
{
     uint32_t oldColor;
     oldColor=BSP_LCD_GetTextColor();
     if (m_state==true) BSP_LCD_SetTextColor(m_colorOn);
     else BSP_LCD_SetTextColor(m_colorOff);
     BSP_LCD_FillRect(m_x,m_y,m_w,m_h);
     BSP_LCD_SetTextColor(oldColor);
    
}

/* Lecture touche dans la zone du bouton */
void button::readState(void)
{
    uint16_t Xpos,Ypos;
    TS_StateTypeDef tsState; // Déclaration d'une structure liée au TouchScreen
    BSP_TS_GetState(&tsState);
    if (tsState.touchDetected)
    {
        Xpos=tsState.touchX[0]; // Lecture de la position
        Ypos=tsState.touchY[0];
        if(( Xpos > m_x) && (Xpos < m_x+m_w) && (Ypos > m_y) && (Ypos < m_y+m_h)) m_state=true;
        else m_state=false;
        
    }
    else m_state=false;
    if (m_state!=m_memoState)
    {
        draw();
        m_memoState=m_state;
    }
    
}
void button::readState(void){}