#include "mbed.h" //inclusion de la bibliothèque mbed
#include "LCD_DISCO_F746NG.h" //bibliothèque de gestion de l'écran LCD

#include "dashboard.h"

//Déclarations des objets globaux
LCD_DISCO_F746NG lcd; //objet lcd pour commander l'écran LCD
Serial pc(USBTX,USBRX);//objet pc pour la liaison usb entre la carte électronique et l'ordinateur
DigitalIn button1(USER_BUTTON); //objet button1 pour la lecture du bouton poussoir
DigitalOut led1(LED1); // objet led1 pour la commande de la LED1

DigitalIn S1(D2); //objet S1 pour la lecture du bouton poussoir S1
DigitalIn S2(D3); //objet S2 pour la lecture du bouton poussoir S2
DigitalOut LED1_kit(D0); // objet LED1 pour la commande de LED1 du kit
DigitalOut LED2_kit(D1); // objet LED2 pour la commande de LED2 du kit

int main()
{
    uint8_t retour=0;
    
    DrawBackground();
 
    while(1)
    {        
        //Attention Bouton poussoir actif au niveau logique bas
        if (S1.read()==0 && S2.read()==0)
        {
            //LED1_kit.write(1);//extinction LED1 par un niveau logique haut
            //LED2_kit.write(1);//extinction LED2 par un niveau logique bas
            FlashLeft(0,5);
            FlashRight(0,5);
        }
        else
        {
            if (S1.read()==0)
            {
                //LED1_kit.write(0);//allumage LED1 par un niveau logique bas
                retour=FlashLeft(1,5);
            }
            else
            {
                //LED1_kit.write(1);//extinction LED1 par un niveau logique haut
                retour=FlashLeft(0,5);
            }
            pc.printf("Test clignotant gauche retour=%d\n",retour);//message de debug
            
            if (S2.read()==0)
            {
                //LED2_kit.write(0);//allumage LED2 par un niveau logique bas
                retour=FlashRight(1,5);
            }
            else
            {
                //LED2_kit.write(1);//extinction LED2 par un niveau logique haut
                retour=FlashRight(0,5);
            }
            pc.printf("Test clignotant droit retour=%d\n",retour);//message de debug
        }
    }
}
