/**
  ******************************************************************************
  * @file    dashboard.h
  * @author  JLP - IUT GEII TOURS
  * @version V1.0.0
  * @date    21-september-2021
  * @brief   This header file contains the common defines and functions prototypes
  *          for car's dashboard
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2021 GEII TOURS/center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __DASHBOARD_H
#define __DASHBOARD_H

#ifdef TARGET_DISCO_F746NG

/* Includes ------------------------------------------------------------------*/
#include "mbed.h"
#include <math.h>
#include "stm32746g_discovery_lcd.h"
#include "background.cpp"

#include "left_dart_on.cpp"
#include "left_dart_off.cpp"
#include "right_dart_on.cpp"
#include "right_dart_off.cpp"

/* Define ---------------------------------------------------------------------*/
#define M_PI        3.14159265358979323846

/* Global declaration ---------------------------------------------------------*/


/* Prototypes ------------------------------------------------------------------*/


// Dessine le fond du tableau de bord
// Paramètre : aucun
// Retour : aucun
void DrawBackground();


// Dessine l'aiguille de l'indicateur de vitesse
// Paramètre : vitesse en km/h
// Retour : 1 si vitesse > 160, 0 sinon
uint8_t DrawSpeedNeedle(uint16_t speed);

// DEssine l'aiguille du compte tours
// Paramètre : vitesse de rotation en tours/minute
// Retour : 1 si vitesse de rotation > 8000, 0 sinon
uint8_t DrawRpmNeedle(uint16_t rpm);

// Dessine l'aiguille de la jauge du réservoir
// Paramètre : % de remplissage
// Retour : 1 si paramètre > 100%, 0 sinon
uint8_t DrawFuelNeedle(uint16_t fuel);

// Affiche et incrméente le compteur kilométrique total
// Paramètre: 1 pour incrémenter, 0 pour uniquement l'afficher
// Retour: 1 si paramètre > 0, 0 sinon
uint8_t DrawTotalKm(uint8_t km);

// Affiche, incrémente ou remet à 0 le compteur journalier
// Paramètre : 1 pour incrémenter le compteur, 0 pour uniquement afficher ou -1 pour remettre à 0
// Retour: 1 if parameter over 1 or under -1, 0 if not
uint8_t DrawDailyKm(int8_t km);

// Affiche la consommation de carburant
// Paramètre : consommation en l/100km
// Retour: 1 si consommation > 30, 0 sinon
uint8_t DrawConsumption(float consumption);

// Affiche le clignotant gauche
// Paramètres : 0 pour éteindre ou 1 pour clignoter / valeur de la fréquence de clignotement
// Retour: 1 si premier paramètre >1, 2 si second parametre > 4, 3 si les deux
uint8_t FlashLeft(uint8_t flash, uint8_t freq );

// Affiche le clignotant droit
// Paramètres : 0 pour éteindre ou 1 pour clignoter / valeur de la fréquence de clignotement
// Retour: 1 si premier paramètre >1, 2 si second parametre > 4, 3 si les deux
uint8_t FlashRight(uint8_t flash, uint8_t freq );

#endif
#endif


/************************ (C) COPYRIGHT GEII TOURS *****END OF FILE****/

