#include "dashboard.h"
DigitalOut CL(D0);
DigitalOut CR(D1);
// Ticker pour clignotant gauche
void FLeft()
{
    static bool On=false;
    if (On)
    {
        BSP_LCD_DrawBitmap(195,0,(uint8_t*) &leftDartOff);
        CL=1;
        On=false;
    }
    else 
    {
        BSP_LCD_DrawBitmap(195,0,(uint8_t*) &leftDartOn);
        CL=0;
        On=true;
    }
}

// Ticker pour clignotant droit
void FRight()
{
    static bool On=false;
    if (On)
    {
        BSP_LCD_DrawBitmap(245,0,(uint8_t*) &rightDartOff);
        CR=1; 
        On=false;
    }
    else 
    {
        BSP_LCD_DrawBitmap(245,0,(uint8_t*) &rightDartOn);
        CR=0;
        On=true;
    }
}
    
// Dessine le fond du tableau de bord    
void DrawBackground()
{
    BSP_LCD_DrawBitmap(0,0,(uint8_t*) &background);
    BSP_LCD_DrawBitmap(195,0,(uint8_t*) &leftDartOff);
    BSP_LCD_DrawBitmap(245,0,(uint8_t*) &rightDartOff);
    CL=1;
    CR=1;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
}


// Dessine l'aiguille de vitesse dans le cadran associé
uint8_t DrawSpeedNeedle(uint16_t speed)
{
    uint8_t ret=0;
    static uint16_t x1=110,y1=121,x2=110,y2=76;
    float angle;
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DrawLine(x1,y1,x2,y2);
    if(speed >160)
    { 
        speed=160;
        ret=1;
    }
    angle=M_PI*(7-8*speed/160.0)/6;
    x1=110+16*cos(angle);
    y1=136-16*sin(angle);
    x2=110+60*cos(angle);
    y2=136-60*sin(angle);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    BSP_LCD_DrawLine(x1,y1,x2,y2);
    return ret;
}

// Dessine l'aiguille de vitesse de rotation dans le cadran associé
uint8_t DrawRpmNeedle(uint16_t rpm)
{
    uint8_t ret=0;
    static uint16_t x1=365,y1=121,x2=365,y2=76;
    float angle;
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DrawLine(x1,y1,x2,y2);
    if(rpm > 8000)
    { 
        rpm=8000;
        ret=1;
    }
    angle=M_PI*(7-8*rpm/8000.0)/6;
    x1=365+15*cos(angle);
    y1=136-15*sin(angle);
    x2=365+60*cos(angle);
    y2=136-60*sin(angle);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    BSP_LCD_DrawLine(x1,y1,x2,y2);
    return ret;
}

// Dessine l'aiguille du réservoir dans le cadran associé
uint8_t DrawFuelNeedle(uint16_t fuel)
{
    uint8_t ret=0;
    static uint16_t x1,x2,y1,y2;
    float angle=0;
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DrawLine(x1,y1,x2,y2);
    if(fuel>100)
    { 
        fuel=100;
        ret=1;
    }
    angle=M_PI*(7-8*fuel/100.0)/6;
    x1=238+6*cos(angle);
    y1=228-6*sin(angle);
    x2=238+15*cos(angle);
    y2=228-15*sin(angle);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    BSP_LCD_DrawLine(x1,y1,x2,y2);
    return ret;
}

// Ajoute 0 ou 1 km au compteur kilométrique total et l'affiche
uint8_t DrawTotalKm(uint8_t km)
{
    uint8_t ret=0;
    char text[20];
    static uint32_t kms=0;
    if(km>1) ret=1;
    if (km==1) kms++;
    sprintf(text,"%07d",kms);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font16);
    BSP_LCD_DisplayStringAt(200,49,(uint8_t*)text,LEFT_MODE);
    BSP_LCD_DisplayStringAt(225,61,(uint8_t*)"km",LEFT_MODE);
    return ret;
}

// Ajoute 0 ou 1 km au compteur kilométrique jounalier et l'affiche. Si -1 le remet à 0
uint8_t DrawDailyKm(int8_t km)
{
    uint8_t ret=0;
    char text[20];
    static uint32_t kms=0;
    if(km>1) ret=1;
    if (km==1) kms++;
    else if (km==-1) kms=0;
    sprintf(text,"%04d",kms);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font16);
    BSP_LCD_DisplayStringAt(90,180,(uint8_t*)text,LEFT_MODE);
    BSP_LCD_DisplayStringAt(97,192,(uint8_t*)"km",LEFT_MODE);
    return ret;
}

// Affiche la consommation
uint8_t DrawConsumption(float consumption)
{
    uint8_t ret=0;
    char text[20];
    if(consumption>30.0)
    {
         ret=1;
         consumption=30.0;
    }
    sprintf(text,"%2.1f",consumption);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font16);
    BSP_LCD_DisplayStringAt(345,180,(uint8_t*)text,LEFT_MODE);
    BSP_LCD_DisplayStringAt(327,195,(uint8_t*)"L/100km",LEFT_MODE);
    return ret;
}

// Affiche le clignotant gauche
uint8_t FlashLeft(uint8_t flash, uint8_t freq )
{
    uint8_t ret=0;
    static bool FlOn=false;
    float Time=0.5;
    if (freq>0 && freq<5) Time=1.0/freq;
    else ret+=2;
    static Ticker TickL;
    switch (flash)
    {
        case 0 : 
            if(FlOn)
            {
                BSP_LCD_DrawBitmap(195,0,(uint8_t*) &leftDartOff);
                CL=1;
                TickL.detach();
                FlOn=false;
            }  
            break;
        case 1 :  
            if(!FlOn)
            {
                TickL.attach(&FLeft,Time);
                FlOn=true;
            }
            break;
        default : ret++;
    }
    return ret;
}

// Affiche le clignotant droit
uint8_t FlashRight(uint8_t flash, uint8_t freq )
{
    uint8_t ret=0;
    static bool FrOn=false;
    float Time=0.5;
    if (freq>0 && freq<5) Time=1.0/freq;
    else ret+=2;
    printf("Clignotant G\n"); // Débogage
    static Ticker TickR;
    switch (flash)
    {
        case 0 : 
            if(FrOn)
            {
                BSP_LCD_DrawBitmap(245,0,(uint8_t*) &rightDartOff);
                CR=1;
                TickR.detach();
                FrOn=false;
            }
            break;
        case 1 : 
            if(!FrOn)
            {
                TickR.attach(&FRight,Time);
                FrOn=true;
            }
            break;
        default : BSP_LCD_DrawBitmap(245,0,(uint8_t*) &rightDartOff);TickR.detach();ret++;
    }
    return ret;
}
    
