#include "mbed.h"
#include "LCD_DISCO_F746NG.h"

#include "audio.c"
#include "gallery.c"
#include "mail.c"
#include "messager.c"
#include "recorder.c"
#include "video.c"
#include "youtube.c"
#include "web.c"

#include "touches.h"

LCD_DISCO_F746NG lcd; // Instanciation du LCD

Serial pc(USBTX, USBRX); // tx, rx

void menu(void);

int main()
{    
    uint8_t touch=0;
    uint8_t application=0;    
    
    lcd.Clear(LCD_COLOR_WHITE);
    menu();
    
    while(1)
    {
        touch=readTouchApp();
        if (touch>0)
        {
            if(application==0)
            {
                application=touch;
                switch(application)
                {
                    case 1:
                        lcd.DisplayStringAt(0,LINE(0),(uint8_t*)"NAVIGATEUR WEB",CENTER_MODE);
                        lcd.DrawRect(20,25,95,95);
                    break;
                    case 2:
                        lcd.DisplayStringAt(0,LINE(0),(uint8_t*)"COURRIEL",CENTER_MODE);
                        lcd.DrawRect(136,25,95,95);
                    break;
                    case 3:
                        lcd.DisplayStringAt(0,LINE(0),(uint8_t*)"MESSAGERIE INSTANTANEE",CENTER_MODE);
                        lcd.DrawRect(252,25,95,95);
                    break;
                    case 4:
                        lcd.DisplayStringAt(0,LINE(0),(uint8_t*)"YOU TUBE",CENTER_MODE);
                        lcd.DrawRect(368,25,95,95);
                    break;
                    case 5:
                        lcd.DisplayStringAt(0,LINE(0),(uint8_t*)"LECTEUR AUDIO",CENTER_MODE);
                        lcd.DrawRect(20,146,95,95);
                    break;
                    case 6:
                        lcd.DisplayStringAt(0,LINE(0),(uint8_t*)"LECTEUR VIDEO",CENTER_MODE);
                        lcd.DrawRect(136,146,95,95);
                    break;
                    case 7:
                        lcd.DisplayStringAt(0,LINE(0),(uint8_t*)"GALLERIE PHOTO",CENTER_MODE);
                        lcd.DrawRect(252,146,95,95);
                    break;
                    case 8:
                        lcd.DisplayStringAt(0,LINE(0),(uint8_t*)"ENREGISTREUR AUDIO",CENTER_MODE);
                        lcd.DrawRect(368,146,95,95);
                    break;
                } // Fin du switch
            } // Fin du if (application==0)
        } // Fin du if(touch>0)
        else
        {
            if (application>0)
            {
                lcd.Clear(LCD_COLOR_WHITE);
                menu();
                application=0;
            }
        }
    }
}

void menu(void) // Dessin du menu avec les 8 icônes
{
    //lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DrawBitmap(20,25,(uint8_t*) &web);
    lcd.DrawBitmap(136,25,(uint8_t*) &mail);
    lcd.DrawBitmap(252,25,(uint8_t*) &messager);
    lcd.DrawBitmap(368,25,(uint8_t*) &youtube);
    lcd.DrawBitmap(20,146,(uint8_t*) &audio);
    lcd.DrawBitmap(136,146,(uint8_t*) &video);
    lcd.DrawBitmap(252,146,(uint8_t*) &gallery);
    lcd.DrawBitmap(368,146,(uint8_t*) &recorder);
    lcd.DisplayStringAt(0,LINE(10)+5,(uint8_t*)"BALADEUR MULTIMEDIA 1.0",CENTER_MODE);
    lcd.SetBackColor(LCD_COLOR_LIGHTGREEN);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.ClearStringLine(0);
}