/**
 * LED Matrix library for http://www.seeedstudio.com/depot/ultrathin-16x32-red-led-matrix-panel-p-1582.html
 * The LED Matrix panel has 32x16 pixels. Several panel can be combined together as a large screen.
 *
 * Coordinate & Connection (mbed -> panel 0 -> panel 1 -> ...)
 *   (0, 0)                                     (0, 0)
 *     +--------+--------+--------+               +--------+--------+
 *     |   5    |    3   |    1   |               |    1   |    0   |
 *     |        |        |        |               |        |        |<----- mbed
 *     +--------+--------+--------+               +--------+--------+
 *     |   4    |    2   |    0   |                              (64, 16)
 *     |        |        |        |<----- mbed
 *     +--------+--------+--------+
 *                             (96, 32)
 *
 */

#include "mbed.h"
#include "LEDMatrix.h"
#include "smallFont.h"

#define WIDTH   128
#define HEIGHT  64

BusOut leds(LED1, LED2, LED3, LED4);
//stb c'est le latch
// LEDMatrix(a, b, c, d, oe_1, r3, r4, b3, b4, g3, g4, g1, r1, b1, r2, g2, b2, stb_1, clk_1,);
LEDMatrix matrix(p12, p13, p14, p15, p18, p25, p23, p24, p21, p26, p22, p9, p8, p10, p7, p11, p6, p17, p16);
Ticker scanner;

// Display Buffer
uint8_t displaybuf[2][WIDTH *HEIGHT] = {
    0x00
};

// Instantiation de Led
DigitalOut Led(LED1);

// Initialisation de la liaison Bluetooth
Serial Bluetooth(p28, p27); // tx, rx

// 16 * 8 digital font
const uint8_t digitals[] = {
    0x00, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00, // 0
    0x00, 0x18, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00, // 1
    0x00, 0x3E, 0x63, 0x63, 0x63, 0x06, 0x06, 0x0C, 0x18, 0x30, 0x63, 0x7F, 0x00, 0x00, 0x00, 0x00, // 2
    0x00, 0x3E, 0x63, 0x63, 0x06, 0x1C, 0x06, 0x03, 0x03, 0x63, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00, // 3
    0x00, 0x06, 0x0E, 0x1E, 0x36, 0x36, 0x66, 0x66, 0x7F, 0x06, 0x06, 0x1F, 0x00, 0x00, 0x00, 0x00, // 4
    0x00, 0x7F, 0x60, 0x60, 0x60, 0x7C, 0x76, 0x03, 0x03, 0x63, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00, // 5
    0x00, 0x1E, 0x36, 0x60, 0x60, 0x7C, 0x76, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00, // 6
    0x00, 0x7F, 0x66, 0x66, 0x0C, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, // 7
    0x00, 0x3E, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x3E, 0x00, 0x00, 0x00, 0x00, // 8
    0x00, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x37, 0x1F, 0x03, 0x03, 0x36, 0x3C, 0x00, 0x00, 0x00, 0x00, // 9
};

// (x, y) top-left position, x should be multiple of 8
void drawDigital(uint16_t x, uint16_t y, uint8_t n)
{
    /*    if ((n >= 10) || (0 != (x % 8))) {
            return;
        }

        uint8_t *pDst = displaybuf + y * (WIDTH / 8) + x / 8;
        const uint8_t *pSrc = digitals + n * 16;
        for (uint8_t i = 0; i < 16; i++) {
            *pDst = *pSrc;
            pDst += WIDTH / 8;
            pSrc++;
        }*/
}


void scan()
{
    matrix.scan();
}

void setup()
{
    // Initialisation Communication et premier message Bluetooth
    Bluetooth.baud(9600);//vitesse de communication
    Bluetooth.format(8,SerialBase::None,1);//

    Bluetooth.printf("\r\n Setup OK !! \r\n");

    // Clignotement led
    Led = 1;
    wait(1);
    Led = 0;
    wait(1);
    Led = 1;
} //End setup

int main()
{
    setup();
    int i, j, c=1;
    
    char carac;
    initFonts();

    matrix.begin((uint8_t *)displaybuf, WIDTH, HEIGHT);
    scanner.attach(scan, 0.0005);

//defilement point
    /*    for (i=0; i<64; i++) {
            for (j=0; j<128; j++) {
                matrix.clear();
                matrix.drawPoint(j,i,4);
                matrix.swap();
                while (!matrix.synchro());
            }
        }
        while (1);
    */
     /*   while(1) {
        if(Bluetooth.readable()) // établir la connection
        {
            carac = Bluetooth.getc(); //On stocke le caractère envoyé dans la variable qu'on tape sur l'interface

            switch(carac) {

            case 'A' :
            
            for (i=138; i>-180; i-=2) {
                matrix.clear();
                matrix.drawCharString(i,5,"Le meilleur ",c,fonts[1]);
                matrix.swap();
                wait(0.05);
                while (!matrix.synchro());
                }
            c++;
            if (c==8) c=1;
            break;
            
            case 'B' :
            
            for (i=138; i>-180; i-=2) {
                matrix.clear();
                matrix.drawCharString(i,5,"IUT Cachan ",c,fonts[1]);
                matrix.swap();
                wait(0.05);
                while (!matrix.synchro());
                    }
            c++;
            if (c==8) c=1;
            break;
                }
        }
    } // end while */

//    matrix.clear();

    uint8_t count = 0;

  //France
       /* matrix.drawRect(0,0,21,64,4);
        matrix.drawRect(21,0,43,64,7);
        matrix.drawRect(43,0,64,64,1);*/
        
        matrix.drawCharString(78,0,"3",7,fonts[2]);   
        matrix.drawCharString(14,0,"3",7,fonts[2]);      
        matrix.swap();
        while (!matrix.synchro());
        wait(1);
        matrix.clear();
     
        matrix.drawCharString(78,0,"2",7,fonts[2]);   
        matrix.drawCharString(14,0,"2",7,fonts[2]);         
        matrix.swap();
        while (!matrix.synchro());
        wait(1);
        matrix.clear();        

        matrix.drawCharString(78,0,"1",7,fonts[2]);      
        matrix.drawCharString(14,0,"1",7,fonts[2]);      
        matrix.swap();
        while (!matrix.synchro());
        wait(1);
        
        
    while (1) {



      
        
         for (i=200; i>-400; i-=4) {
                matrix.clear();
                matrix.drawCharString(i,0,"Comment est votre blanquette ? ",c,fonts[1]);
                matrix.drawCharString(i,32,"              ma blanquette est bonne ",c,fonts[1]);
                matrix.swap();
                wait(0.05);
                while (!matrix.synchro());
                }
            c++;
            if (c==8) c=1;

      //  for (i=64; i>-192; i--) {
    
    // matrix.drawChar(0,0,'A',2,fonts[0]);
    //matrix.drawChar(10,0,'A',2,fonts[1]);
    //matrix.drawChar(20,0,'A',3,fonts[2]);

    }

}

 