/* Copyright (c) 2017 STMicroelectronics
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/****************************************************
*           RAPID PROTOTYPING WITH NUCLEO           *
* Example Code 11: Servo pwm                        *
* Author: Mauro D'Angelo                            *
* Organization: STMicroelectronics                  *
*****************************************************/

#include "mbed.h"
#include "Servo.h"

//Instantiate an object of Servo type on pin PB_3 named servo
Servo servo(PB_3);

//Instantiate an object of DigitalOut type on pin LED1 named myled
DigitalOut myled(LED1);

//Instantiate an object of Serial type on Tx and Rx pin of USB port named pc (being the USB port connected to PC)
Serial pc(USBTX, USBRX);


//Entry point
int main() {

    //Define and set angle variable
    int angle = 0;

    while(1) {
        //Modify servo position
        servo.write(angle);
      
        // Print angle
        pc.printf("Servo set at %d degrees\r\n", angle);

        // Modify LED status (toggle)
        myled = !myled;

        //Increase angle value
        angle+=10;

        //If angle increases more than 180 degrees, reset
        if(angle>360)
            angle=0;

        wait(0.25);
    }
}
