#include "mbed.h"
#include "rtos.h"
#include "hcsr04.h"
#include "beep.h"
#include "TextLCD.h"
#include "Servo.h"
#define trigger1 PC_8 //sensore 1
#define echo1 PC_6
#define trigger2 D12  //sensore 2
#define echo2 D13
#define trigger3 PC_10    //sensore 3
#define echo3    PC_12
#define trigger4   D6  //sensore 4
#define echo4  D8
/******************************/
//bluetooth
Serial pc(USBTX, USBRX);             //istanza oggetto porta seriale
Servo servo(D9); 
Servo uscita(D7);                    //istanza oggetto servomotore
TextLCD lcd(D10,D11,D5,D4,D3,D2);    //istanza oggetto schermo
/******************************/
//sensori ad ultrasuoni

HCSR04 sensor1(trigger1, echo1);     //istanza oggetto sensore a distanza
HCSR04 sensor2(trigger2, echo2);
HCSR04 sensor3(trigger3, echo3);
HCSR04 sensor4(trigger4, echo4);
/******************************/
DigitalIn mybutton(PC_3);     //istanza oggetto bottone
//Thread thread_sensori; // istanzia oggetto thread 

bool occupata[5] = { false, false, false,false, false}; 
int numero_parcheggi = 4;

//dichiarazione vettore booleano che indica gli stati del parcheggio 
/*******************************************************************************************************/
/* stato del parcheggio :
   occupata = false; il parcheggio è libero
   occupata = true; il parcheggio è occupato */
   
/******************************/ 
 void button_thread(void const *args)
 {
     bool sos = false;
     int angle = 0;

     while(1)
     {
        if (mybutton == 0)
        {
           
            int i = 0;
            sos = false;
            
            do{
                if (i < numero_parcheggi)    i++;
                else    break;
            
                   if(occupata[i] == false)
                   {
                        if(sos == false)
                        {
                            
                            pc.printf(" parcheggio %d \r\n", i);       //stampa quali parcheggi sono liberi
                            lcd.cls();   
                            lcd.printf(" parcheggio %d \r\n", i); 
                              
                            sos = true;    
                            break;     
                        }                                        //se un parcheggio è libero conseguentemente non possono essere tutti occupati
                        while(1) 
                        {
                            uscita.write(angle);                      //non toccare 
                            angle += 10;
                            if(angle > 90)
                            {
                                wait(3);
                                while(angle != 0 )
                                {
                                    uscita.write(angle);
                                    angle -= 10;
                                    wait(0.25); 
                                }
                                if(angle == 0) break;
                            }
                            wait(0.25);
                        }
             
                }
            
           } while(1);   
           
              if(sos == true)
              {
              while(1)
              {
                            uscita.write(angle);                      //non toccare 
                            angle += 10;
                            if(angle > 90)
                            {
                                wait(3);
                                while(angle != 0 )
                                {
                                    uscita.write(angle);
                                    angle -= 10;
                                    wait(0.25); 
                                }
                                if(angle == 0) break;
                            }
                            wait(0.25);
                }     
            }                                              
            if (sos == false)
                {
                    pc.printf("parcheggio pieno");
                    lcd.cls();
                    lcd.printf("parcheggio pieno");
    

                }
           
        }
        
           
    }
}

/******************************/
void sensori()
{
        /*float distanza1;
        float distanza2;
        float distanza3;*/
        sensor1.start();
        wait_ms(100);
        sensor2.start();         //partono i sensori 
        wait_ms(100);  
        sensor3.start();
        wait_ms(100);
        sensor4.start();
        wait_ms(100);
        bool sos;

        if(sensor1.get_dist_cm() <= 10.0)   occupata[1] = true;
        else    occupata[1] = false;
        
        if(sensor2.get_dist_cm() <= 10.0)    occupata[2] = true;
        else    occupata[2] = false;
        
        if(sensor3.get_dist_cm() <= 10.0)    occupata[3] = true;
        else    occupata[3] = false;
        
        /*if(sensor4.get_dist_cm() <= 10.0)    occupata[4] = true;
        else    occupata[4] = false;*/
        
        if(sensor4.get_dist_cm() <= 10.0)
        {
                int angle = 0;
                while(1)
                {
                    servo.write(angle);                      //non toccare 
                    angle += 10;
                    if(angle > 90)
                    {
                        wait(3);
                        while(angle != 0 )
                        {
                            servo.write(angle);
                            angle -= 10;
                            wait(0.25); 
                        }
                        
                        if(angle == 0)     break;
                    }
                    wait(0.25);
                }                                                  // ciclo infinito, segnalera sempre i parcheggi liberi
         }
        
        
}     

int main()
{

        Thread button_th(button_thread);
        
        while(1)
        {
             sensori();
        }
}
    
/**************L'HTML È UN LINGUAGGIO DI PROGRAMMAZIONE**************/