#include "mbed.h"
#include "rtos.h"
#include "hcsr04.h"
#include "beep.h"
#include "TextLCD.h"
#include "Servo.h"
#define trigger1 D15
#define echo1 D14
#define trigger2 D12
#define echo2 D13
#define trigger3 PC_6
#define echo3    PC_8

/******************************/
//bluetooth
Serial pc(USBTX, USBRX);             //istanza oggetto porta seriale
Servo servo(D9);                     //istanza oggetto servomotore
TextLCD lcd(D10,D11,D5,D4,D3,D2);    //istanza oggetto schermo
/******************************/
//sensori ad ultrasuoni

HCSR04 sensor1(trigger1, echo1);     //istanza oggetto sensore a distanza
HCSR04 sensor2(trigger2, echo2);
HCSR04 sensor3(trigger3, echo3);
/******************************/
DigitalIn mybutton(D7);     //istanza oggetto bottone
//Thread thread_sensori; // istanzia oggetto thread 

bool occupata[] = { false, false, false }; 
int numero_parcheggi = 3;

//dichiarazione vettore booleano che indica gli stati del parcheggio 
/*******************************************************************************************************/
/* stato del parcheggio :
   occupata = false; il parcheggio è libero
   occupata = true; il parcheggio è occupato */
   
/******************************/ 
 void button_thread(void const *args)
 {
     bool sos = false;
     int angle = 0;

     while(1)
     {
        if (mybutton == 0)
        {
           
            int i = 0;
            sos = false;
            
            do{
                if (i < numero_parcheggi)    i++;
                else    break;
            
                   if(occupata[i] == false)
                   {
                        pc.printf("il parcheggio numero %d e libero\r\n", i);       //stampa quali parcheggi sono liberi
                        lcd.printf("il parcheggio numero %d e libero\r\n", i);      
                        sos = true;                                                 //se un parcheggio è libero conseguentemente non possono essere tutti occupati
                        while(1) 
                        {
                            servo.write(angle);                      //non toccare 
                            angle += 10;
                            if(angle > 90)
                            {
                                wait(3);
                                while(angle != 0 )
                                {
                                    servo.write(angle);
                                    angle -= 10;
                                    wait(0.25); 
                                }
                           if(angle == 0) break;
                        }
                        wait(0.25);
                    }
              //if(occupata[1] == false && occupata[2] == false)    break;     // if(occupata[1]==true && occupata[2]==true) //sos = !sos;
                }/*else if(sos==false && i==2){
                    pc.printf("tutti i parcheggi sono occupati");
                    break;
                    }//else if(occupata[1]==true && occupata[2]==true) pc.printf("tutti i parcheggi sono occupati");
           */
            
        } while(1);                                                       // ciclo infinito, segnalera sempre i parcheggi liberi
           //  if(occupata[1]==true && occupata[2]==true) pc.printf("tutti i parcheggi sono occupati");
          /*  if (sos == false)
                {
                    pc.printf("tutti i parcheggi sono occupati\r\n");
                    lcd.printf("tutti i parcheggi sono occupati\r\n");
                }
            else 
            {
                 lcd.printf("per riavviare premere l'apposito pulsante");
                 pc.printf("per riavviare premere l'apposito pulsante");
            }*/
        }
        
           
    }//chiusura iterazione del pulsante
}// chiusura funzione 
//sensore semaforo 1
/******************************/
void sensori()
{
      // bool controllo;
       // float distanza1;
       // float distanza2;
        sensor1.start();
        wait_ms(100);
        sensor2.start();         //partono i sensori 
        wait_ms(100);  
        sensor3.start();
        wait_ms(100);
        //distanza1= sensor1.get_dist_cm() ;  
        //distanza2=sensor2.get_dist_cm();
        //pc.printf("%.0fcm\r\n%.0fcm\r\n", distanza1,distanza2);
        if(sensor1.get_dist_cm() < 10.0 && occupata[0] ==  false)   occupata[1] = true;
        else    occupata[0] = false;
            
        if(sensor2.get_dist_cm() < 10.0 && occupata[2] == false)    occupata[2] = true;
        else    occupata[2] = false;
        
        if(sensor3.get_dist_cm() < 10.0 && occupata[3] == false)    occupata[3] = true;
        else    occupata[3] = false;
        
}          
void inizio(){
for(int i=1;i<3;i++){
        if(occupata[i]==true) bool controllo=0;
        else{
             controllo=1;
             break;
             }
        }
    }
int main(){

        while(1){
        inizio();
        if(controllo==0) lcd.printf("occupato\r\n");
        else lcd.printf("libero\r\n");
         }
        Thread button_th(button_thread);
        while(1)
        {
             sensori();
        }
}
    
