/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 09: DC motor control                 *
* Author: Mauro D'Angelo                            *
* Organization: Perlatecnica no-profit organization *  
*****************************************************/
#include "mbed.h"

#define PWMB PA_7
#define DIRB PA_5

#define PWMA PB_3
#define DIRA PA_6

// Instanzia un oggetto di tipo PwmOut  e gli da il nome mypwm
PwmOut mypwm(PWMB);
// Definisce il pin che indica la direzione
PwmOut mypwm2(DIRB);

// Instanzia un oggetto di tipo DigitalOut sul pin LED1 e gli da il nome myled
DigitalOut myled(LED1);

// Instanzia un oggetto di tipo Serial sui pin Tx e Rx della porta USB e gli da il nome pc (trattandosi della porta USB connessa al PC)
Serial pc(USBTX, USBRX);

// Entry point
int main() {
    //motordir = 1;
    
    //Set pwm signal period: The period needed to control the motor in the servo datasheet
    mypwm.period_ms(10); 
    mypwm.pulsewidth(0.01); // 100%
    //mypwm.pulsewidth(0.005); // 50%
    //mypwm.pulsewidth(0.002); // 20%
  
    while(1) {;}
}