#include "mbed.h"
#include "DHT.h"
#include "TextLCD.h"
#define   DHT_DATA_PIN  D7

TextLCD lcd(D10,D11,D5,D4,D3,D2); // rs, e, d4-d7
Serial out(USBTX,USBRX);
DHT sensor(DHT_DATA_PIN, DHT11);                    //DHT(PinName pin, eType DHTtype)
 
int main()
{
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
 
  //  while(1) 
    {
        wait(2.0f);                                 //wait 2 second
        error = sensor.readData(); 
       // c   = sensor.ReadTemperature(CELCIUS);                 //read error value
      //   out.printf(" Celcius: %4.2f",c);
        if (error == 0)                             //case: no error 
        {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            //dp  = sensor.CalcdewPoint(c, h);
            //dpf = sensor.CalcdewPointFast(c, h);
            lcd.printf("Temp: %4.1f C \n", c);
            lcd.printf("Umid: %4.1f \n", h);
            
            printf("Temperature in Kelvin: %4.2f, Celcius: %4.2f, Farenheit %4.2f\n", k, c, f);
            printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\n", h, dp, dpf);
        } 
        else                                        //case: error
        {
            printf("Error: %d\n", error);
        }
    }
}