#include "mbed.h"
 
Serial bt(D10,D2);  // D10 va su RX; D2 va su TX
Serial pc(USBTX,USBRX);
DigitalOut myled(D13);
 
int main()
{
    bt.baud(9600);
    //prints data on mobile
    bt.printf("Connection Established");
    //print data on pc terminal
    pc.printf("Connection Established");
    while(1) {
        //For reading and writing data from/to bluetooth HC-06
        //check if bluetooth is readable and execute commands to toggle LED
        if (bt.readable()) {
            char input_key=  bt.putc(bt.getc());
            //tutn on LED if "y" is entered
            if(input_key == 'y') {
                myled = 1;
                bt.printf("LED is ON");
            }
            //tutn on LED if "n" is entered
            if(input_key == 'n') {
                myled = 0;
                bt.printf("LED is OFF");
            }
        }
 
        //For reading and writing data from/to pc terminal
        //check if pc is readable and execute commands  to toggle LED
        if (pc.readable()) {
            char input_key=  pc.putc(pc.getc());
 
            if(input_key == 'y') {
                myled = 1;
                pc.printf("LED is ON");
            }
            if(input_key == 'n') {
                myled = 0;
                pc.printf("LED is OFF");
            }
        }
    }
}
 