#include "mbed.h"
#include "rtos.h"
#include "hcsr04.h"
#include "beep.h"
/******************************/
//bluetooth
Serial blue(D10,D2);//tx e rx
/******************************/
//sensori ad ultrasuoni
HCSR04 sensor1(D15, D14);
HCSR04 sensor2(D12, D13);
HCSR04 sensor3(D11, D9);
/******************************/
//dichiarazioni led
//Led per le macchine
DigitalOut rossoC(PA_0);
DigitalOut gialloC(D5);
DigitalOut verdeC(D3);
/******************************/
//led per i pedoni
DigitalOut rossoP(D6);
DigitalOut gialloP(D7);
DigitalOut verdeP(D8);
/******************************/
//buzzer
Beep buzzer(D4);
/******************************/
/******************************/
//dichiarazione funzioni
void giallo();
void semafori();
/******************************/
//variabili
int i=0;
char riceviBlue = '0';
bool gianello= false;
bool visto = false;
/******************************/ 
 
//sensore semaforo 1
/******************************/
void sensori(){
    while(!visto && !gianello){
        sensor1.start();
        wait_ms(100);
        sensor2.start();
        wait_ms(100);
        if(sensor1.get_dist_cm()<10||sensor2.get_dist_cm()<10){
            wait(4);
            sensor1.start();
            wait_ms(100);
            sensor2.start();
            wait_ms(100);
            if(sensor1.get_dist_cm()<10||sensor2.get_dist_cm()<10&&!gianello){
               visto = true;
                blue.putc('A');                
                wait_ms(100);
                semafori();
                visto=false;
            }
        }
    }     
}
/******************************/
//controllo borini 
/******************************/
void borini (void const *args){
    while(true){
        if(blue.readable()){
            riceviBlue = blue.getc();
        }
        if(riceviBlue == 'B')
        {
            gianello=true;
            riceviBlue='0';
            semafori();
            riceviBlue='0';
            gianello=false;
            visto=false;
        }
    }
}
/******************************/
int main(){
   //inizializzazione
   /******************************/
   rossoP=1;
   verdeP=0;
   gialloP=0;
   gialloC=0;
   rossoC=0;
   verdeC=1;
   blue.baud(38400);
   /******************************/
Thread th1(borini);  
    while(1){
       if(!gianello){
            sensori();
        }
    }  
}
void giallo(){
    int n;
    int cont =0;
    do{
            n=0;
            verdeP=0;
            gialloP=1;       
           //bippata del buzzer
           /******************************/
            for(i=0;i<10;i++){
                buzzer.beep(1500,50);
                wait_ms(200);
                buzzer.nobeep();
                buzzer.beep(2000,50);
                wait_ms(200);
                buzzer.nobeep();                                
            } 
            /******************************/
            sensor3.start();
            wait_ms(100);
            if(sensor3.get_dist_cm()<48){
               cont++;
               if(cont<=2)
                blue.putc('L');
               n=1;               
            }
            wait_ms(100);            
    }while(n==1&&cont<=2);
    blue.putc('0');      
    wait_ms(200);
}
void semafori(){
    //giallo per le macchine, rosso per i pedoni       
            verdeC=0;
            gialloC=1;
            rossoC=0;
            wait(4);
            //rosso per le macchine, verde per i pedoni
            buzzer.beep(1200,50);  
            gialloC=0;
            rossoC=1;            
            rossoP=0;
            verdeP=1;            
            wait(10);
            buzzer.nobeep();
            //giallo per i pedoni e rosso per le macchine   
            giallo();
            //rosso ai pedoni e verde alle automobili
            gialloP=0;
            rossoP=1; 
            rossoC=0;
            verdeC=1;
            wait_ms(5000);
}