/* mbed Program: Proyecto Cronometro mediante multiplexado de D7S */
#include "mbed.h"//Libreria para elementos básicos de mbed-OS
#include "constantes.h"//Libreria de cabecera para almacenamiento de constantes
#include "fnc_usuario.h"//Libreria para declaración de funciones de usuario

/******************************************************************************/
//Declaración para la utilización de hardware del sistema 
Ticker imp_d7s;                                                                 //Interrupción temporizada para impresión en D7S multiplexados
Ticker temp_cronometro;                                                         //Interrupción temporizada para cuantificación del tiempo del sistema
DigitalOut led1(PTD5);                                                          //TEstigo led Verde
DigitalOut led2(PTE29);                                                         //Testigo Led Rojo
DigitalIn sw_arranque(PTD4);                                                    //Entrada digital para iniciar la cuantificacion de tiempo del sistema
DigitalIn sw_paro(PTD2);                                                        //Entrada digital para parar la cuantificación de tiempo del sistema
DigitalIn sw_reset(PTA13);                                                      //Entrada digital para reseteo de variables del sistema
BusOut pines_disp7S(PTA17, PTB9, PTA7,PTA6,PTA14,PTA16,PTA15,PTC16);            //Pines reservados para la impresión de información en los segmentos de los display
BusOut pines_transist(PTC9,PTC8,PTA5,PTA4,PTA12,PTD3);                          //pines reservados para el control de transistores para conmutar displays

/******************************************************************************/
//Variables utilizadas para la logica del sistma
int contador_digitos;                                                           //Contador para la impresión de datos en los displays
int contador_ms;                                                                //Contador para cuantificacion de milisegundos
int contador_decms;                                                             //Contador para cuantificacion de decenas de milisegundos
int contador_seg;                                                               //Contador para cuantificacion de segundos
int contador_min;                                                               //Contador para cuantificacion de minutos
int impresion_d7s[6];                                                           //Vector para almacenar información de los digitos a imprimir en D7S
bool band_arranque;                                                             //Bandera para arranque del sistema


/******************************************************************************/
//Tablas para control de grupos de pines, D7S y multiplexado
int cod_disp7s[DIGITOS_D7S_ANODO]={0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F}; //Codigo para vizualización de D7S de anodo comun   
int codigo_transist[MUX_D7S]={0x01,0x02,0x04,0x08,0x10,0x20};                   //Tabla para despliegue del digito 0 al 5   
int codigo_transist_2[MUX_D7S]={0x20,0x10,0x08,0x04,0x02,0x01};                 //Tabla para despliegue del digito 5 al 0


/******************************************************************************/
//Rutina de Atención a la Interrupción para realizar la impresión de datos en el multiplexado de los D7S
void impres_d7s() {//inicio ISR para impresión de D7S
    pines_disp7S=cod_disp7s[(impresion_d7s[contador_digitos])];                 //Asignación de codigos para despliegue de datos en pines de segmentos de D7S
    pines_transist=codigo_transist_2[contador_digitos];                         //Asignación de codigo para la conmutación de D7S
    contador_digitos--;                                                         //Contador decremental para variable de control de conmutación de D7S
    if(contador_digitos<0)                                                      //Condición para numeros menores a cero, reset de variable contadora
        contador_digitos=5;                                                     //Reset de variable contadora para inicio en D7S #5
}//fin ISR para impresión de D7S


/******************************************************************************/
//Rutina de Atención a la Interrupción para la cuantificación del tiempo del sistema
void conteo_tiempo(){//inicio ISR para cuantificación de tiempos
     if(band_arranque==VERDADERO){                                              //Condición de arranque de la cuantificación del sistema
     contador_ms++;}                                                            //Variable contadora para cuantificacion de milisegundos del sistema
     led1 = !led1;                                                              //luz testigo para indicación de trabajo en el MCU

}//fin ISR para cuantificación de tiempos

/******************************************************************************/ 
int main() {//inicio funcion principal
/*----------------------------------------------------------------------------*/    
//Inicialización de variables y vinculacion de ISR a los servicios de interrupción    
    imp_d7s.attach(&impres_d7s, 0.001);                                         //viculación de la función de interrupción a la ISR para la vinculación de la impresión de datos en el D/S
    temp_cronometro.attach(&conteo_tiempo,0.001);                               //viculación de la función de interrupción a la ISR para la cuantificación de tiempo
    contador_digitos=5;                                                         //Inicialización de la variable contadora para impresión de los displays
    band_arranque=FALSO;                                                        //Inicialización de variable para el control de inicio de operación del sistema
    
/*----------------------------------------------------------------------------*/ 
//Inicio looop de trabajo iterativo
   
    while(1) {//inicio loop de trabajo
    
    if(sw_arranque==VERDADERO){//Inicio if-1                                    //Pregunta por el estado del boton arranque
        band_arranque=VERDADERO;                                                //Habilitación de la bandera de arranque del sistema
        wait_ms(50);                                                            //Retardo de tiempo para la eliminación del rebote en el interruptor
        }//fin if-1
        
    if(sw_paro==VERDADERO){//Inicio if-2                                        //Pregunta por el estado del boton paro
        band_arranque=FALSO;                                                    //Deshabilitación de la bandera de arranque del sistema
        wait_ms(50);                                                            //Retardo de tiempo para la eliminación del rebote en el interruptor
        }
    if(sw_reset==VERDADERO){//Inicio if-3                                       //Pregunta por el estado del boton paro
        band_arranque=FALSO;                                                    //Deshabilitación de la bandera de arranque del sistema
        contador_ms=0;                                                          //Reset contador de milisegundos
        contador_decms=0;                                                       //Reset contador de decenas de milisegundos
        contador_seg=0;                                                         //Reset contador de segundos
        contador_min=0;                                                         //Reset contador de minutos
        
        for(int i=0;i<6;i++){                                                   //Loop para reseteo de variable para impresion de información en D7S
            impresion_d7s[i]=0;                                                 //Limpieza de dato para D7S
            }
        wait_ms(50);                                                            //Retardo de tiempo para la eliminación del rebote en el interruptor
        }//fin if-3
    
    //Sección de cuantificación de decenas de milisegundo
    if(contador_ms>DECENAS_MS){//inicio if-4                                    //condicion para el incremento de decenas de milisegundos
                contador_decms++;                                               //Incremento de variable contadora de decenas de milisegundos
                num2dig(contador_decms,&impresion_d7s[0],&impresion_d7s[1]);    //Transformación del contador de decenas de milisegundos a digitos y almacenaje para despliegue en D7S
                contador_ms=0;                                                  //Reset contador de milisegundos
                }//fin if-4
        //Sección de cuantificación de segundos    
    if(contador_decms==MS2SEG){//inicio if-5                                    //condicion para el incremento de segundos
                contador_seg++;                                                 //Incremento de variable contadora de segundos
                num2dig(contador_seg,&impresion_d7s[2],&impresion_d7s[3]);      //Transformación del contador de segundos a digitos y almacenaje para despliegue en D7S
                contador_decms=0;                                               //Reset contador de decenas de milisegundos
                }//fin if-5
        //Sección de cuantificación de minutos        
    if(contador_seg==SEG2MIN){//inicio if-6                                     //condicion para el incremento de minutos
                contador_min++;                                                 //Incremento de variable contadora de minutos
                num2dig(contador_min,&impresion_d7s[4],&impresion_d7s[5]);      //Transformación del contador de minutos a digitos y almacenaje para despliegue en D7S
                contador_seg=0;                                               //Reset contador de decenas de segundos
                }//fin if-6
        //Candado para la cuantificación de minutos        
    if(contador_min==MIN){//inicio if-7                                         //Condicion para el reset de minutos
                contador_min=0;                                                 //Reset de la variable contadora de minutos
                }//fin if-7    
        
    }//fin loop de trabajo

}//Fin función principal