#include "mbed.h"
 ////PINES PARA KL-46Z
 ///%%%%MISO%%%% se conecta al divisor para no dañar el micro puesto que la entrada digital es de 3.3v y el mcp regresa 5v
 // SI=MOSI
 // SO=MISO
 // SO Directo al divisor de voltaje, entrada a las r 2.35k ohms 
 // salida del divisor a tierra directo intermedio a miso 4.7k ohms
 // Se conecta al SPI 0 para no interrumpir la acción de los estados de los leds 
SPI spi(PTA16, PTA17, PTA15); // mosi, miso, sclk
DigitalOut cs(PTA14);
// en caso de instalar barra de leds referida a tierra se invierte la polaridad es decir 1=on
// en el micro estan referidos a voltaje 1=off
// se invertiria el en¿cendido de los leds con la barra!!
DigitalOut myled(PTD5); //led verde
DigitalOut resetled(PTE29); //led rojo
 
 
int main()
{
    myled = 1;
    resetled = 1;
    // Chip must be deselected
    cs = 1;
 
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(1000000);
 
    while (1) {
 
        // Select the device by seting chip select low
        resetled = 0;
        cs = 0;
        // Send 0xC0, the command to reset the MCP2515 chip
        spi.write(0xC0);
        printf("Resetting the MCP2515 chip.\r\n");
        // Deselect the device
        cs = 1;
        wait_ms(10);
        resetled = 1;
 
        // Select the device by seting chip select low
        cs = 0;
        // Send 0xA0, the command to read the MCP2515 Status register
        spi.write(0xA0);
        // Send a dummy byte to receive the contents of the status register
        int status = spi.write(0x00);
        printf("status register = 0x%02X.\r\n", status);
        // Deselect the device
        cs = 1;
 
        // Select the device by seting chip select low
        cs = 0;
        // Send 0x03, the command to read an MCP2515 register
        spi.write(0x03);
        // Send 0x0F, the address of the MCP2515 CANCTRL register
        spi.write(0x0F);
        // Send a dummy byte to receive the contents of the status register
        int CANCTRL = spi.write(0x00);
        printf("CANCTRL register = 0x%02X.\r\n", CANCTRL);
        // Deselect the device
        cs = 1;
 
        wait(1);
        myled = !myled;
    }
}