#include "mbed.h"
#include "TextLCD.h"
TextLCD lcd(PC_8, PC_6, PB_14, PB_15, PB_1, PB_2);
Ticker timer;
DigitalOut sc1(PC_5),sc2(PC_4);
AnalogIn pote(A0);
CAN can1(PA_11, PA_12); //rd td
CAN can2(PB_12,PB_13);
CANMessage msg;
PwmOut mypwm(LED1);
AnalogIn Pote(PC_0);
float variable=0;

int volt=0;

void send()
{
    volt=pote.read_u16()/(256);
    //volt=volt/100;
    char datos[8]= {volt,0,0,0,0,0,0,0};
    can1.write(CANMessage(550,datos,1 ));
    printf("\n %d",volt);
}
void read()
{
    can2.read(msg);
    if(msg.id==550) {
        variable=msg.data[0]/25.5;
        lcd.locate(3,0);
        lcd.printf("%d ",msg.id);
        lcd.locate(13,0);
        lcd.printf("%d ",msg.len);
        lcd.locate(0,1);
        for (int i=0; i<msg.len; i++) {
            lcd.printf("%d ",msg.data[0]);
        }
        mypwm.period_ms(10);
        mypwm.pulsewidth_ms(variable);
    }
    return;
}
int main()
{
    timer.attach(&send,0.1);
    can2.attach(&read,CAN::RxIrq);
    lcd.locate(0,0);
    lcd.printf("ID");
    lcd.locate(11,0);
    lcd.printf("L");
}