#include "stm32f103c8t6.h"
#include "mbed.h"
#include "MPU6050.h"
#include "TextLCD.h"

 
SPI spi_lcd(PB_15, NC, PB_13);
MPU6050 mpu(PB_7, PB_6); // SDA, SCL pines de la comunicacion I2C 
TextLCD_SPI lcd(&spi_lcd, PB_12, TextLCD::LCD16x2,TextLCD::HD44780); // SPI bus, CS pin, LCD Type ok
DigitalOut ledr(PB_5);   //Led de conexion fallida 
DigitalOut ledg(PB_4);   //Led de conexion OK
DigitalOut ledb(PB_3);   //Led de envio de datos serial

float AX,AY,AZ;  // variables para la conversion a aceleracion en m/s^2
int estado=1; // variable que hacer repetir el ciclo de conexion con el MPU hasta que haya una conexion I2C satisfactoria
int ax,ay,az; /// variables a imprimir
int contador=0;

int main() {
    lcd.cls();
    wait(0.50);
    //Posicionar al LCD en el espacio 0,0  ORIGEN
    lcd.locate(0,0);
    lcd.printf("Start PowerTip");
    wait(1.0);
    lcd.cls();
    
    ledr=0; //inicializacion de led (conexion fallida) off
    ledg=0; //inicializacion de led (conexion OK) off
    ledb=0; //inicializacion de led (envio de datos) off
 
    int accdata[3];  //se aparta el arreglo para la adquisiscion de datos de la aceleración
    int gyrodata[3]; //se aparta el arreglo para la adquisicion de datos del giroscopio 
    
    while(estado){ // inicia bucle para reconocimiento del estado 
    wait_ms(100);     // retardo para el inicio de las variables 
    if (mpu.testConnection()){ // lectura del estado de conexion del MPU 6050 
        lcd.printf("MPU connection succeeded\n\r"); //imprime en patalla que la conexion fue OK 
        
        //lcd.cls();
        estado=0; // cambio de estado de la variable se sale del ciclo una vez que la conexion esta OK
        ledg=1; // si la (conexion OK) led green enciende
        
        }
    else{
        lcd.printf("MPU connection failed\n\r");// Imprime en pantalla que la conexión fue fallida 
        //lcd.cls();
        estado=1; //Estado permanence en uno repitiendo el ciclo while(estado)
        ledr=1;  ///si la (conexion fallida) led rojo enciende
         
        }
        // retardo para preguntar sobre la conexion del MPU
        wait_ms(1000); /// Se hace cada segundo si es que la conexion fue fallida
        }
        ledr=0; // Se apaga led red una vez que la conexion fue OK 
    while(1) {
        contador++;
        //MPU6050_ACCEL_XOUT_H_REG se piden los datos de esta direcion
        // definición de los registros para pedir datos de acelerometro
        //MPU6050_ACCEL_XOUT_H_REG   0x3B
        //MPU6050_ACCEL_YOUT_H_REG   0x3D
        //MPU6050_ACCEL_ZOUT_H_REG   0x3F
        
        mpu.getAcceleroRaw(accdata); //Funcion para mandar llamar los datos del acelerometro
        
        mpu.getGyroRaw(gyrodata);  // funcion para mandar llamar los datos del giroscopio
        
        ax=(accdata[0])+(4175);  ///compenzación del offset del sensor
        ay=(accdata[1])-(12759); ///compenzación del offset del sensor
        az=(accdata[2])-(14029); ///compenzación del offset del sensor
        
        ///impresion de pantalla de lo datos puros de aceleracion 
        //pc.printf("Accelero data: X: %d - Y: %d - Z: %d\n\r", accdata[0], accdata[1], accdata[2]); 
       
        lcd.printf("X");       //Identificador para el software LABVIEW
        lcd.printf("%d ",ax); //Imprime los datos de aceleracion en 'X'
        lcd.printf("Y");       //Identificador para el software LABVIEW
        lcd.printf("%d ",ay); //Imprime los datos de aceleracion en 'Y'
        lcd.printf("Z");       //Identificador para el software LABVIEW
        lcd.printf("%d ",az); //Imprime los datos de aceleracion en 'Z'
       // lcd.cls();
        /// Impresion de panatalla de los datos del giroscopio
        /// pc.printf("Gyro data: X: %d - Y: %d - Z: %d\n\r\n\r", gyrodata[0], gyrodata[1], gyrodata[2]);
        if(contador==10)
        {
           ledb=!ledb;  //Cambio de estado del led blue (da un tono azul) al encender blue con green
        //indica un envio de datos serial correcto 
         contador=0;
            }
        
        
        wait_ms(100); // Retardo sincronizado con la interfaz grafica para el envio de datos
    }
        
        
}