/*************************************/
//  YNCREA ISEN CSI3
//  Electronique Numérique
//
//  Cours : Systèmes à microcontrôleur
//  Prof : Frédéric Giamarchi
//
//  Projet 2021 : Jeu type Simon's pour la rééducation
//
//  Note : Utilisation de Timer et du SPI
//
//  Code pour le node 01
/*************************************/
#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>
#include "isen32_board.h"

Serial pc(USBTX, USBRX);        // 9600 baud par défaut

#define nrf_CE      PB_3        // D3 sur connecteur Arduino        
#define nrf_CSN     PB_12
#define spi_MOSI    PB_15
#define spi_MISO    PB_14
#define spi_SCK     PB_13

// Module nRF24 sur SPI2
RF24 radio(spi_MOSI, spi_MISO, spi_SCK, nrf_CE, nrf_CSN );

// Network uses that radio
RF24Network network(radio);

// Address of our node
const uint16_t this_node = 02;

// Address of the other node
const uint16_t other_node = 00;

// How often to send payload packet to the other unit
//const unsigned long interval = 1000; //ms

// When did we last send?
unsigned long last_sent;
Timer t;

// How many have we sent already
unsigned long packets_sent;
Timer t_packet;

// Structure of our payload
struct payload_t 
{
    uint8_t src;        // Source du message
    uint8_t dest;       // Destination du message
    uint8_t data;       // Data du message
};

struct _node
{
    uint8_t src;        // Source du message
    uint8_t dest;       // Destination du message
    uint8_t del;
};

int main()
{
    Init_Spi();
    Affiche_Display(this_node);
    
    _node node;
       
    BTN1.mode(PullUp);    // Resist interne Pull up
//    pc.baud(9600);
    wait_ms(1000);

    pc.printf("mBed RF24Network node : %d\r\n",this_node);
    radio.begin();
    network.begin(/*channel*/ 90, /*node address*/ this_node);
    wait_ms(2000);
    t.start();
    t_packet.start();
    
    
    while(1) 
    {
        // Refresh Dels
//        Set_8Dels(node.del);
        
        // Pump the network regularly
        network.update();

        /* If it's time to send a message, send it! */
/*        unsigned long now = t.read_ms();
        if ( now >= interval  ) 
        {
            t.reset();

            pc.printf("Envoi...");
            payload_t payload_tx;
            if(!BP)
                payload_tx.num = 01;
            else
                payload_tx.num = 00;
                
            payload_tx.del++;


            RF24NetworkHeader header_tx(other_node);    // vers node "other_node"
            bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));
            if (ok)
                pc.printf("ok.\r\n");
            else
                pc.printf("erreur.\r\n");
                
                
        }
        */
        while ( network.available() ) 
        {
            // If so, grab it and print it out
            RF24NetworkHeader header_rx;
            payload_t payload_rx;
            network.read(header_rx,&payload_rx,sizeof(payload_rx));

            pc.printf("Node %d recu de node %d, data : %d\r\n",this_node,payload_rx.src,payload_rx.data);
            
            node.del = payload_rx.data;
        }
        if(!BTN1 || !BTN2)
        {
            node.del++;
            payload_t payload_tx;
            payload_tx.src = this_node;
            payload_tx.data = node.del%5;
            
            if(!BTN1)
                payload_tx.dest = 00;
            if(!BTN2)
                payload_tx.dest = 01;    
            
            pc.printf("Envoi...");

            RF24NetworkHeader header_tx(other_node);    // vers node "other_node"
            bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));
            if (ok)
                pc.printf("ok.\r\n");
            else
                pc.printf("erreur.\r\n");
            wait_ms(1000);
        }
    }
}