#include "mbed.h"

// Nucleo Board associé à la carte ISEN

DigitalOut Led1(LED1);      // PA5 attention SPI CLK aussi
DigitalIn BTN_User(PC_13);

// ISEN32 Board
/*
DigitalOut L0(PB_1);        // Dels, en sortie, reliée à PB1
DigitalOut L1(PB_2);
DigitalOut L2(PB_10);
DigitalOut L3(PB_11);
DigitalOut L4(PB_12);
DigitalOut L5(PB_13);
DigitalOut L6(PB_14);
DigitalOut L7(PB_15);       // la plus à gauche
*/
DigitalIn BTN1(PA_11);       // Bouton Poussoir, en entrée, relié à PA11
DigitalIn BTN2(PA_12);
DigitalIn BTN3(PC_6);
DigitalIn BTN4(PC_5);

DigitalOut BZ1(PC_7);       // Buzzer, en sortie, relié à PC7

//DigitalOut M1(PB_4);       // Moteur mini, en sortie, relié à PB4
//PwmOut M1(PB_4);        // Moteur mini en mode PWM

// Lignes pour entrées analogiques
AnalogIn RV1(A0);           // RV1, en entrée analogique, relié à PA0
AnalogIn RV2(A1);           // RV2, en entrée analogique, relié à PA1
AnalogIn SENSOR(A4);        // Pour capteur externe, exemple capt. de temp. MCP9700 Attention en conflit possible avec DAC

// Lignes SPI pour piloter le MAX7219
SPI spi(PA_7, PA_6, PA_5);
DigitalOut CS(PA_8);

// Lignes I2C
//DigitalOut SCL(PB_6);
//DigitalOut SDA(PB_7);

// Adresses des 2 EEPROMs I2C
#define EEPROM1 0b1010000
#define EEPROM2 0b1010001

// Lignes pour piloter des servomoteurs
//DigitalOut SERVO1(PB_9);
//DigitalOut SERVO2(PB_8);
//DigitalOut SERVO3(PC_8);
//DigitalOut SERVO4(PC_9);

// Lignes pour piloter 2 moteurs DC
//DigitalOut EN1(PB_10);
//PwmOut EN1(PB_10);
//DigitalOut IN1(PB_1);
//DigitalOut IN2(PB_2);
/*
void Set_8Dels(uint8_t position)
{
    L0 = position & 0x01;
    L1 = position & 0x02;
    L2 = position & 0x04;
    L3 = position & 0x08;
    L4 = position & 0x10;
    L5 = position & 0x20;
    L6 = position & 0x40;
    L7 = position & 0x80;
}
*/
/* MAX7219 : Interface SPI pour afficheur 7 segments */
void Init_Spi(void)
{
    spi.format(16,3);           // SPI en mode 16 bits

    CS = 0;
//    spi.write(0x0F01);          // Test Display On
//    spi.write(0x0F00);          // Test Display Off
    spi.write(0x0C01);
    CS = 1;

    CS = 0;
//    spi.write(0x090C);          // Mode BCD sur 2 digits
    spi.write(0x090F);          // Mode BCD sur 4 digits
    CS = 1;

    CS = 0;
    spi.write(0x0A01);          // Intensité à 3/15
    CS = 1;

    CS = 0;
    spi.write(0x0B03);          // Format Display 0 1 2 3
    CS = 1;

//    CS = 0;
//    spi.write(0x0F01);
//    CS = 1;
//    wait_ms(1000);
    CS = 0;
    spi.write(0x0F00);          // Test mode Off
    CS = 1;

    CS = 0;
    spi.write(0x0101);          // Chiffre des milliers
    CS = 1;
    CS = 0;
    spi.write(0x0282);          // Chiffre des centaines
    CS = 1;
    CS = 0;
    spi.write(0x0303);          // Chiffre des dizaines
    CS = 1;
    CS = 0;
    spi.write(0x0404);          // Chiffre des unités
    CS = 1;
}

void Affiche_Display(uint16_t valeur)
{
uint8_t ch_4, ch_3, ch_2, ch_1;

    ch_4 = valeur/1000;
    valeur = valeur - ch_4*1000;
    ch_3 = valeur/100;
    valeur = valeur - ch_3*100;
    ch_2 = (valeur/10);
    valeur = valeur - ch_2*10;
    ch_1 = valeur;
    
    CS = 0;
    spi.write(0x0100 | ch_4);          // Chiffre des milliers
    CS = 1;
    CS = 0;
    spi.write(0x0280 | ch_3);          // Chiffre des centaines avec le point (8)
    CS = 1;
    CS = 0;
    spi.write(0x0300 | ch_2);          // Chiffre des dizaines
    CS = 1;
    CS = 0;
    spi.write(0x0400 | ch_1);          // Chiffre des unités
    CS = 1;
}
