/*************************************/
//  YNCREA ISEN CSI3
//  Electronique Numérique
//
//  Cours : Systèmes à microcontrôleur
//  Prof : Frédéric Giamarchi
//
//  Projet 2021 : Jeu type Simon's pour la rééducation
//
//  Note : Test module nRF24L01 en mode SPI
//
//  Code pour la base 00
/*************************************/
#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>
#include "isen32_board.h"

Serial pc(USBTX, USBRX);        // 9600 baud par défaut

#define nrf_CE      PB_3        // D3 sur connecteur Arduino        
#define nrf_CSN     PB_12
#define spi_MOSI    PB_15
#define spi_MISO    PB_14
#define spi_SCK     PB_13

// Module nRF24 sur SPI2
RF24 radio(spi_MOSI, spi_MISO, spi_SCK, nrf_CE, nrf_CSN );

// Network uses that radio
RF24Network network(radio);

// Variables
uint8_t etat;
uint8_t adr_tx;

// Address of our node
const uint16_t this_node = 00;

// Address of the other node
//const uint16_t node_01 = 01;
//const uint16_t node_02 = 02;
//const uint16_t node_03 = 03;

// Structure of our payload
struct payload_t {
    uint8_t src;        // Source du message
    uint8_t dest;       // Destination du message
    uint8_t data;       // Data du message
};

struct _node {
    uint8_t src;        // Source du message
    uint8_t dest;       // Destination du message
    uint8_t del;
};

int main()
{
    etat = 0;
//  Test de l'horloge Systeme
//    pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);
    Init_Spi();
    Affiche_Display(this_node);
    /*    Set_8Dels(1);
        wait_ms(1000);
        Set_8Dels(0);
      */
    _node node;

    pc.printf("mBed RF24Network Base 00\r\n");
    radio.begin();

// Choix du canal de communication (128 canaux disponibles, de 0 à 127)
// et numéro de l'émetteur, ici le node 00
    network.begin(/*canal*/ 90, /*node address*/ this_node);
    wait_ms(2000);

    while(1) {
        // Refresh Dels
//        Set_8Dels(node.del);

        // Pump the network regularly
        network.update();

//  Machine d'états en mode réception par défaut
        switch (etat) {
            case 0:         //  ---> Reception <---
                while ( network.available() ) {     // Si réception
                    RF24NetworkHeader header_rx;    // Création d'un entête
                    payload_t payload_rx;           // Création d'une structure pour le message
                    network.read(header_rx,&payload_rx,sizeof(payload_rx));     // Lecture du message
                    pc.printf("Node %d -> Node %d : msg %d\r\n", payload_rx.src, payload_rx.dest, payload_rx.data);

                    if (payload_rx.dest == 00) {
                        node.del = payload_rx.data%6;
                    }
                    else {
                        etat = 1;
                        node.src = payload_rx.src;
                        node.dest = payload_rx.dest;
                        node.del = payload_rx.data;
                    }
                }
                break;
            case 1:         //  ---> Emission <---
                //               RF24NetworkHeader header_tx;
                payload_t payload_tx;
                payload_tx.src = node.src;
                payload_tx.dest = node.dest;
                payload_tx.data = node.del;
                pc.printf("Envoi...");
                RF24NetworkHeader header_tx(payload_tx.dest);
                bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));
                if (ok) {
                    pc.printf("ok.\r\n");
                } else
                    pc.printf("erreur.\r\n");

                etat = 0;
                break;
            default:
                etat = 0;
                break;
        }   // switch

    }   // while(1)
    return 0;
}   // main