// Programa que realiza una cuenta de 0 a 9999 usando 4 displays de Anodo comun 
// e interrupciones por Timers y externa.

//Motor amarillo a 3v -> 125rpm
// a 6v -> 230rmp (3.83H)  a 5v -> 208rmp (3.47H) = (100/347) real 147.6 rpm -> 2.46H

#include "mbed.h"

Ticker Tick_Desplegar,Tick_Velocidad;            //Interrupciones 
InterruptIn Sensor(PTB11);                       // Interrupcion externa 
AnalogIn Pot(PTC11);                             // Señal analogica
PwmOut Motor(PTC10);                             // Señal de PWM 

BusOut Display(PTC3,PTC2,PTA2,PTB23,PTA1,PTB9,PTC17,PTC16);  // A,B,C,D,E,F,G,DP
BusOut Comunes (PTA0,PTC4,PTD0,PTD2); // D4,D3,D2,D1

const unsigned short Numeros [10]= {0xC0,0xF9,0xA4,0xB0,0x99,0x92,0x82,0xF8,0x80,0x90}; // Bits de numeros para cada display
                                                                                        //0,1,2,3,4,5,6,7,8,9
                                                                                        //Para displays de catodo comun 
                                                                                        // 0x3F,0X06,0X5B,0X4F,0X66,0X6D,0X7D,0X07,0X7F,0X6F
const unsigned short Comun [4] = {14,13,11,7}; //Digitos para Comunes de displays D1-D4

void VerDisplay (int Numero);  // Funcion de conversion 
void Int_Contar (void);       // Funcion para contar cada Interrupcion
void Flip_Desplegar(void);     // Funcion para desplegar en cada display 
void Flip_Velocidad (void);    // Funcion para variar el PWM


int Contador = 0;              // Varieble usada para contar
int x = 0;                     // Variable usada para establecer que comun prender
short Digito[4] = {0,0,0,0};   // Arreglo usado para guardar convercion U,D,C,UM  



int main (void)
{
    Motor.period(0.001);   //periodo del motor 
    Comunes = 255;    //Apagar todo. 
    Display = 255;
    
     Tick_Desplegar.attach(&Flip_Desplegar, 0.0001);  //Llamado de interrupciones estableciendo tiempo a interrumpir
     Tick_Velocidad.attach(&Flip_Velocidad, 0.1);
     Sensor.rise(&Int_Contar);                        // Interrupcion cada flanco de subida 
    
    while (1)   //ciclo infinito 
    {  
        }
}

void VerDisplay (int Contador)
{
    
    unsigned short D,C,UM;
    
    UM = Digito[3] = Contador/1000;              // Millar
    C = Digito[2] = (Contador-UM*1000)/100;      // Centenas
    D = Digito[1] = (Contador-UM*1000-C*100)/10; // Decenas
    Digito[0] = (Contador-UM*1000-C*100-D*10);   // Unidades
} 

void Int_Contar(void)
{
    
    
    VerDisplay (Contador);            //Sentencia para evitar que cuante más de 9999
    if (Contador < 10000)
    {
        Contador ++;
        }
    else 
    {
        Contador = 0;
        }      
    
}

void Flip_Desplegar(void)
{
     
    Comunes = 255;  //Borrar comunes para engañar al ojo humano aparentando todos los displays estan prendidos
    
    if (x <= 3)                   //Despliega por 1ms el digito correspondiente a cada display
    {
    Display = Numeros[Digito[x]];
    Comunes = Comun[x] ; 
    x++;   
    }
    else 
    {
     x=0;
     }   
    }

void Flip_Velocidad(void)
{ 
    
    Motor.write(Pot.read());            //Lee la entrada analogica y pone su porcentaje
                                        // en el PWM
   
}  