#include "mbed.h"
#include "rtos.h"
#include "WIZnetInterface.h"
#define INIT 0x1
#define SOCKET 0x2
#define CLIENTE 0x4
#define WEB 0x8

SPI spi(PTD7, PTD6, PTD5); // mosi, miso, sclk
WIZnetInterface eth(&spi, PTD4, PTA20); // spi, cs, reset
Serial pc(PTA2,PTA1);
TCPSocketServer server; 
TCPSocketConnection client;   

int aceptado=1;
int ret;
int control;
int dummy;
int ready;
char paq_en[64];
char a[]={"HTTP/1.0 200 OK\r\nContent-Type: text/html\r\nPragma: no-cache\r\n\r\n"};
char b[]={"<html>\r\n<body>\r\n"};
char c[]={"<title>FRDM KL46Z</title>\r\n"};
char d[]={"<h2>Pagina Web usando Wiznet </h2>\r\n"};
char e[]={"<br /><hr>\r\n"};
char f[]={"<FONT FACE=\"Arial\" SIZE=\"2\" COLOR=\"FF0000\">"};

const char * IP_Addr    = "169.254.175.210";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "169.254.175.209";


void f_ethernet_init(void);



//TASK INICIALIZAR ETHERNET//////////////////////////////////////
void TASK_InitEthernet(void const *argument)
{
    while(true)
    {
        Thread::signal_wait(INIT);
        f_ethernet_init(); 
        control=SOCKET; 
    }
}
/////////////////////////////////////////////////////////////////

//TASK SOCKET////////////////////////////////////////////////////
void TASK_Socket(void const *argument)
{
    while(true)
    {
        Thread::signal_wait(SOCKET);
        control=0;
        //TCPSocketServer server;          //crea servidor
        server.bind(80);   //Puerto
        server.listen();                 //Escucha por clientes
        pc.printf("\nEsperando conexion con cliente...\n");
       // TCPSocketConnection client;      //Realiza la conexion con clientes
        aceptado=server.accept(client);
        if(!aceptado)
        {
            control=CLIENTE;
            pc.printf("Conectado");
        }
        else
        pc.printf("Fallo la conexion con cliente");
    }
}
////////////////////////////////////////////////////////////////

///TASK_CLIENTE/////////////////////////////////////////////////
void TASK_Cliente(void const *argument)
{
     Thread::signal_wait(CLIENTE);
     control=0;
     client.send(a,sizeof(a));
     client.send(b,sizeof(b));
     client.send(c,sizeof(c));
     client.send(d,sizeof(d));
     client.send(e,sizeof(e));
     client.send(f,sizeof(f));
     ready=1;
}
/////////////////////////////////////////////////////////////////


///TASK_WEB//////////////////////////////////////////////////////
void TASK_Web(void const *argument)
{
     while(true)
     {
     Thread::signal_wait(WEB);  
     control=0;
     client.send(paq_en,sizeof(paq_en));  
     } 
}
/////////////////////////////////////////////////////////////////

int main()
{
    Thread thread1(TASK_InitEthernet);
    Thread thread2(TASK_Socket);
    Thread thread3(TASK_Cliente);
    Thread thread4(TASK_Web);
    
    thread1.signal_set(INIT);
    
    while(1)
    {
    if(control==SOCKET)
    thread2.signal_set(SOCKET);
    wait(0.5);
    if(control==CLIENTE)
    thread3.signal_set(CLIENTE);
    
    while(ready&&client.is_connected())
    {
       wait(1);
       dummy++;
       sprintf(paq_en,"<FONT><BR>Valor=%d</FONT>",dummy);
       thread4.signal_set(WEB);
    }
     
    }
     
}



void f_ethernet_init()
{
     uint8_t mac[]={0x00,0x08,0xDC,0x1C,0xAA,0xCA};
   // mbed_mac_address((char *)mac); 
    pc.printf("\tIniciando Servidor Ethernet...\n\r");
    wait(1);
    ret = eth.init(mac, IP_Addr, IP_Subnet, IP_Gateway);
    if(!ret)
    {
        pc.printf("Inicializado, MAC= %s\n\r",eth.getMACAddress());
    }    
    else
    {
        pc.printf("Fallo comunicacion... Reinicie dispositivos...\n\r");    
    }
    pc.printf("Conectando.");
    wait(2);
    pc.printf(".");
    wait(2);
    pc.printf(".\n\r");
    wait(1);
    ret = eth.connect();
    if(!ret)
    {
        pc.printf("Conexion Establecida!\n\n\r");
        wait(1);
        pc.printf("IP=%s\n\rMASK=%s\n\rGW=%s\n\r",eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    }    
    else
    {
        pc.printf("Fallo conexion... Reinicie dispositivos...\n\r"); 
    }
}  

