/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32F103C8_Plantilla_Enhenced
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed
**    Compilador     : Mbed Online C Compiler
**    Version        : Mbed-OS 5.15.0
**    Fecha/Hora     : 18-12-2019, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, PWM, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:                       I N C L U D E S
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
//#include "AnalogIn.h"
//#include "PwmOut.h"
//#include "Led_RGB.h"
//#include <stdio.h>
//#include <conio.h>
//#include <stdlib.h>
/*
:...............................................................................
:                       D E F I N I C I O N E S
:...............................................................................
*/
#define LED_ON          0           // Estado para el Led Encendido
#define LED_OFF         1           // Estado para el Led Apagado
#define BUZZ_ON         1           // Estado para Buzzer Encendido
#define BUZZ_OFF        0           // Estado para Buzzer Apagado
#define ON              0           // Estado para boton presionado
#define OFF             1           // Estado para boton sin presionar
#define HOLD            2           // Estado para boton mantenido
#define RELEASE         3           // Estado para boton liberado
#define FALSE           0           // Estado FALSO
#define TRUE            1           // Estado VERDADERO
#define TICKER_RATE     1000        // Periodo de Interrupción (us)
#define BAUD_RATE       115200      // Velocidad de Transmisión (Bauds)
                                    // Velocidades Permitidas:
                                    // 300, 600, 1200, 2400, 4800, 9600,
                                    // 14400, 19600, 28800, 38400, 57600
                                    // 115200, 230400
/*
+------------------------------------------------------------------------------+
|             C O N F I G U R A C I O N    D E     P U E R T O S               |
+------------------------------------------------------------------------------+
*/
Ticker      TimerInt;               // Inicializa la Interrupción por Timer
DigitalOut  Led_Monitor(LED1);      // Inicializa el LED Monitor (Interno)
DigitalOut  Led_Testigo(PB_1);      // Inicializa el LED Testigo (Externo)
PwmOut      Pwm1(PA_7);             // Inicializa el PWM para el LED Externo
PwmOut      Buzzer(PB_0);           // Inicializa el PWM para el Buzzer Externo
AnalogIn    Sensor1(PA_1);          // Inicializa Canal Analógico para Potenciometro 1
Serial      Terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial a la PC (Rx, Tx)
/*
+-------------------------------------------------------------------------------
|               V A R I A B L E S    G L O B A L E S                           |
+-------------------------------------------------------------------------------
*/
uint16_t  v_rate=TICKER_RATE/2;     // Velocidad de barrido (500us = 0.5ms)
uint16_t  v_counter=250;            // Cuenta inicial de 250us
uint16_t  v_blink=0;                // Cuenta inical de parpadeos
uint16_t  v_cuenta=0;               // Cuenta inical de parpadeos del LED
/* END variables */

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
        // Las Definiciones de Funciones Prototipo 
        // y Apuntadores a Vectores de Interrupciones van aquí !
void TimerInt_OnInterrupt(void);
void Blinking_Led(void);
void Clear_Screen(void);
void Buzzer_Beep(void);
void Setup(void);
/* END prototypes */

/* END definitions */
/*
#===============================================================================
||                                                                            ||
||                  P R O G R A M A     P R I N C I P A L                     ||
||                                                                            ||
#=============================================================================== 
*/
int main()                  // El código secuencial comienza aquí
{
//+++++++++++++++++++ Secuencia  Principal +++++++++++++++++++++++++++++++++++++                               
//       Inicialización de variables, puertos, interrupciones y carátula                    
  Setup();                  // Inicialización de puertos, interrupciones y condiciones iniciales
  Clear_Screen();           // Limpia la pantalla de la Terminal  
//+++++++++++++++++++ Lazo Principal +++++++++++++++++++++++++++++++++++++++++++
//            El Lazo del Programa principal está aquí !!!
  while (true)
  {
    Blinking_Led();         // Parapadeo del LED por Software
    Pwm1 = Sensor1.read();     // Lee el Potenciometro y cambia el PWM 
    v_cuenta++;
    Terminal.printf("\rLED Testigo Parpadea %d Veces ... \n\r",v_cuenta);                           
  }
}
/* END main */

/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::              V E C T O R E S    D E     I N T E R R U P C I Ó N
::                  (Rutinas de Atención a Interrupciones)
::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
                // Las Rutinas de Atención a Interrupciones van aquí !
/*
** =============================================================================
**     Vector      :  TimerInt_OnInterrupt()
*/
/*!
**     @brief
**         Called after Ticker is done, [Interrupt service/event]
**         and it is enabled: 
**         TimerInt.attach_us(&TimerInt_OnInterrupt, Ticker_Rate);
**         the event is enabled and will be executed every  [Ticker_Rate]
**     @param
**         UserDataPtr     - Pointer to the user or
**                           RTOS specific data. The pointer is passed
**                           as the parameter of Init method.
*/
/* ========================================================================== */
void TimerInt_OnInterrupt()         // Rutina de Atención al Ticker
{
    v_counter--;                    // Aquí va la Rutina de Servicio !
    if (!v_counter)
    {
        v_blink++;
        Terminal.printf("\rLED Monitor Flashing %d Times !!! ",v_blink);
        Led_Monitor = !Led_Monitor; // Parapadeo del LED por Interrupción (LED Toggled)
        v_counter = v_rate;         // Restablece el contador, Le asigna el periodo de 0.5ms (Rate=500)
    } 
}
/* END Events */   
/*
 ______________________________________________________________________________
/______________________________________________________________________________\
|                                                                              |
|                   F U N C I O N E S     P R O T O T I P O                    |
|______________________________________________________________________________|
\______________________________________________________________________________/
*/
                // Las Funciones Prototipo van aquí !
/*
|-------------------------------------------------------------------------------
|     Función     :     Setup()
|      
|     Descripción :     Inicialización de variables, puertos e interrupciones
|
|     Parámetros  :     Ninguno
|          
|     Retorna     :     Nada
|-------------------------------------------------------------------------------
*/
void Setup()    
{
    confSysClock();            // Inicialización del Sistema, Configure system clock (72MHz HSE clock, 48MHz USB clock)
    TimerInt.attach_us(&TimerInt_OnInterrupt, TICKER_RATE);   // Le asigna el periodo de interrupción de 1ms (TICKER_RATE=1000)
    Terminal.baud(BAUD_RATE);  // Se configura la velocidad de transmisión e inicia la comunicación serial.    
    Terminal.printf("The System is Wake Up!.\n\r"); 
    Buzzer_Beep();             // Prueba el Buzzer    
}
/*
|-------------------------------------------------------------------------------
|     Función     :     Blinking_Led()
|      
|     Descripción :     Rutina para Parpadeo del Led por Software
|
|     Parámetros  :     Ninguno
|          
|     Retorna     :     Nada
|-------------------------------------------------------------------------------
*/
void Blinking_Led()             // Software Blinking routine for LED 
{
        // The on-board LED is connected, via a resistor, to +3.3V (not to GND). 
        // So to turn the LED on or off we have to set it to 0 or 1 respectively
    Led_Testigo = LED_ON;        // turn the LED on (using Positive Logic)
    wait_ms(200);           // 200 millisecond
    Led_Testigo = LED_OFF;        // turn the LED off (using Positive Logic)
    wait_ms(1000);          // 1000 millisecond
}

/*
|-------------------------------------------------------------------------------
|     Función     :     Clear_Screen()
|      
|     Descripción :     Limpia la Pantalla de la Terminal
|
|     Parámetros  :     Ninguno
|          
|     Retorna     :     Nada
|-------------------------------------------------------------------------------
*/
void Clear_Screen() 
{
    // ANSI Terminal Commands
    Terminal.printf("\x1B[2J");     // secuencia de Escape  \e[2J
    Terminal.printf("\x1B[H");      // secuencia de Escape  \e[H
}

/*
|-------------------------------------------------------------------------------
|     Función     :     Buzzer_Beep()
|      
|     Descripción :     Rutina para prueba del Buzzer
|
|     Parámetros  :     Ninguno
|          
|     Retorna     :     Nada
|-------------------------------------------------------------------------------
*/
void Buzzer_Beep()                      // Software routine for Buzzer Beep
{ 
  Terminal.printf("Testing Buzzer... \n\r");
  Buzzer = BUZZ_ON;
  wait_ms(750);
  Buzzer = BUZZ_OFF;
  wait_ms(125);
  Buzzer = BUZZ_ON;
  wait_ms(250);
  Buzzer = BUZZ_OFF;   
  wait_ms(125);
  Buzzer = BUZZ_ON;
  wait_ms(500);
  Buzzer = BUZZ_OFF;
  Terminal.printf("Buzzer OK ! \n\r");
}
/* END functions */    
                
/* END program */

/*
*+******************************************************************************
*+                  D O C U M E N T A C I Ó N
*+******************************************************************************
*+                  La documentación va aquí!:
*+
*+------------------------------------------------------------------------------
*+                  IDENTIFICADORES
*+------------------------------------------------------------------------------
*+
*+ prefijo      signifcado              uso    
*+  v_          variable  (var)         v_nombre_variable
*+  c_          constante (const)       c_nombre_constante
*+  i_          indice    (index)       i_nombre_indice
*+  p_          apuntador (pointer)     p_nombre_apuntador
*+  l_          etiqueta  (label)       l_nombre_etiqueta
*+  f_          función   (function)    f_nombre_funcion
*+
*+------------------------------------------------------------------------------
*+  Conexión al Led Testigo:
*+------------------------------------------------------------------------------
*+
*+  Los leds se pueden conectar a cualquier pin que se declare como DigitalOut. 
*+  El dispositivo puede drenar hasta 20ma por todas sus salidas a un voltaje de 
*+  3.3V, pero se recomienda no exceder de 1mA por salida.
*+  Esto se logra poniendo una resistencia limitadora de mínimo 330 Ohms.
*+
*+    3.3V o 5V
*+       O
*+       |
*+       |
*+       /
*+       \   1K
*+       /
*+       \                         UTILIZANDO LÓGICA NEGATIVA
*+       |
*+    ___|___
*+    \      /
*+     \    /
*+      \  /
*+     __\/__
*+       |
*+       |__________________________  PIN (Digital Out)
*+
*+
*+
*+
*+                    1K
*+
*+        _________/\  /\  /\  _____    PIN (Digital Out)
*+       |           \/  \/  \/
*+       |
*+       |
*+    ___|___
*+    \      /
*+     \    /
*+      \  /                       UTILIZANDO LÓGICA POSITIVA
*+     __\/__
*+       |
*+       |
*+       |
*+    ___|___
*+     _____
*+      ___
*+       _
*+
*+      GND
*+
*+------------------------------------------------------------------------------
*+ Descripción del Conexionado para el Buzzer Piezo-Eléctrico
*+------------------------------------------------------------------------------
*+
*+                  100
*+  PWM Pin  -----/\/\/\/-------|
*+                              | 
*+                              |  +
*+                             ( ) 
*+                            ( o ) BUZZER
*+                             ( )
*+                              |
*+                              |
*+                              |
*+                            -----
*+                             ---
*+                              -
*+
*+------------------------------------------------------------------------------
*+  Conexión al Potenciometro:
*+
*+  Como recomendación hay que poner un filtro pasa bajas para evitar que el 
*+  ruido al convertidor analógico/digital.
*+
*+      3.3V
*+       O
*+       |
*+       |
*+       |          Conexión de los Potenciometros
*+       |
*+       /
*+       \  10K 
*+       /          100
*+       \  <----/\/\/\/\-------------->  PIN (AnalogIn Pin)
*+       \                  |
*+       /                  |
*+       \                -----   0.1uF
*+       |                -----
*+       |                  |
*+       |                  |
*+       |                  |
*+    ___|___            ___|___
*+     _____              _____
*+      ___                ___
*+       _                  _
*+
*+      GND                GND
*+
*+
*+      Conexión al Joy Stick Keyes
*+
*+           1   2   3   4   5
*+          GND Vcc VrX VrY SW
*+
*+
*+
*+------------------------------------------------------------------------------
*+  Conexión hacia la Terminal Serial:
*+------------------------------------------------------------------------------
*+
*+  Los Transeptores recomedados para se pueden conectar a los siguientes pines
*+  de las UART's que posee la Bluepill por medio del siguiente conexionado.
*+
*+  UART1   UART2   UART3      CABLE        CP2102  PL2303  CH340G  FT232RL
*+  PA_9    PA_2    PB_10   Tx  ------> Rx    3       2       2        3
*+  PA_10   PA_3    PB_11   Rx  <------ Tx    4       3       3        2
*+                          3V  ------  3V    5       5       4        1
*+                          GND ------  GND   2       1       1        4
*+------------------------------------------------------------------------------
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved
*+
*+  Welcome to The Beaners Proyect Community!                
*+----------------------------------------------------------------------------*/

/* END documentation */ 

/* END Mbed */