/* FsHandler.cpp */
#include "mbed.h"
#include "FsHandler.h"
//#define DEBUG
#include "hl_debug.h"

DigitalOut led_red(LED1);
DigitalOut led_green(LED2);
DigitalOut led_blue(LED3);

DigitalIn  din(PC_14);
AnalogIn   ain0(A0);
AnalogIn   ain1(A1);

static int matchstrings(const char* one, const char* two)
{
    int m = 0;
    
    for (m = 0; m < min(strlen(one), strlen(two)) ; m++) {
        if (one[m] != two[m])
            return m;
    }
    return m;
}

std::map<const char*, const char*> HTTPFsRequestHandler::m_fsMap;
 
HTTPFsRequestHandler::HTTPFsRequestHandler(const char* rootPath, const char* localPath, HTTPConnection::HTTPMessage& Msg, TCPSocketConnection& Tcp)
    : HTTPRequestHandler(Msg, Tcp)
{
    m_rootPath = rootPath;
    m_localPath = localPath;
    
    string myPath = m_rootPath + m_localPath;
    
    //  Now replace the virtual root path with a mounted device path
    std::map<const char*, const char*>::iterator it;
    const char *bestMatch = NULL;
    const char *bestMatchExchange = NULL;
    int match_ind = -1;
    for (it = m_fsMap.begin() ; it != m_fsMap.end() ; it++) {
        //  find best match (if the given logical path is containted in the root
        int s = matchstrings(myPath.c_str(), it->second);
        INFO("Matching Root %s with handler %s results in %d identical characters\n", myPath.c_str(), it->second, s);
        if ((s == strlen(it->second)) && (s > match_ind)) {
            match_ind = s;
            bestMatch = it->first;
            bestMatchExchange = it->second;
        }
    }

    if (bestMatch != NULL) {
        m_rootPath = bestMatch;
        m_localPath = string(myPath).substr(strlen(bestMatchExchange));
    }
            
    handleRequest();
}

HTTPFsRequestHandler::~HTTPFsRequestHandler()
{
}

std::map<int, EthernetInterface*> HTTPFsRequestHandler::m_eth_list;

int HTTPFsRequestHandler::handleGetRequest()
{
    HTTPHeaders headers;
    EthernetInterface test_eth;
    int retval = 0;   //success
    
    if( std::string::npos != msg.uri.find("get_netinfo.cgi") )
    {
        char buf[256];
                
        sprintf(buf, "NetinfoCallback({\"mac\":\"%s\",\"ip\":\"%s\",\"sn\":\"%s\",\"gw\":\"%s\",\"temp\":\"%s\"});"
                    ,m_eth_list[0]->getMACAddress(),m_eth_list[0]->getIPAddress(),m_eth_list[0]->getNetworkMask(),m_eth_list[0]->getGateway());
                
        tcp.send(buf, strlen(buf));
    }
    
    else if( std::string::npos != msg.uri.find("get_ain.cgi") )
    {        
        char buf[256];
        
        sprintf(buf, "AinCallback({\"ain_v0\":\"%.3f\",\"ain_v1\":\"%.3f\"});",ain0.read()*100, ain1.read()*100);
                
        tcp.send(buf, strlen(buf));
    }
    
    else //read html pages
    {
        if (m_localPath.length() > 4) 
            getStandardHeaders(headers, m_localPath.substr(m_localPath.length()-4).c_str());
        else
            getStandardHeaders(headers);
        
        INFO("Handling Get Request (root = %s, local = %s).", m_rootPath.c_str(), m_localPath.c_str());
        
        std::string reqPath;
    
        //  Check if we received a directory with the local bath
        if ((m_localPath.length() == 0) || (m_localPath.substr( m_localPath.length()-1, 1) == "/")) {
            //  yes, we shall append the default page name
            m_localPath += "index.html";
        }
        
        reqPath = m_rootPath + m_localPath;
        
        INFO("Mapping \"%s\" to \"%s\"", msg.uri.c_str(), reqPath.c_str());
            
        FILE *fp = fopen(reqPath.c_str(), "r");
        if (fp != NULL) {
            char * pBuffer = NULL;
            int sz = 8192;
            while( pBuffer == NULL) {
                sz /= 2;
                pBuffer = (char*)malloc(sz);
                if (sz < 128)
                    error ("OutOfMemory");
            }
            
            //  File was found and can be returned
        
            //  first determine the size
            fseek(fp, 0, SEEK_END);
            long size = ftell(fp);
            fseek(fp, 0, SEEK_SET);
        
            startResponse(200, size);
            while(!feof(fp) && !ferror(fp)) {
                int cnt = fread(pBuffer, 1, sz , fp);
                if (cnt < 0)
                    cnt = 0;
                processResponse(cnt, pBuffer);
            }
            delete pBuffer;
            endResponse();
            fclose(fp);
        }
        else {
            retval = 404;
            ERR("Requested file was not found !");
        }
    }
    
    return retval;
}

int HTTPFsRequestHandler::handlePostRequest()
{
    
    int pin = 0;
    
    if( std::string::npos != msg.uri.find("set_dio.cgi") )
    {
        pin = get_http_param_value("pin");
        if(pin == 8)
        {
            led_red = get_http_param_value("val");
        }
        else if(pin == 9)
        {
            led_green = get_http_param_value("val");
        }
        else if(pin == 5)
        {
            led_blue = get_http_param_value("val");
        }
        else
        {
            WARN("Wrong pin number");
        }   
        
        return 0;
    }    
    else
    {
           return 404;
    }
}

int HTTPFsRequestHandler::handlePutRequest()
{
    return 404;
}

uint32_t HTTPFsRequestHandler::get_http_param_value(char* param_name)
{
    uint8_t * name = 0;
    uint8_t * pos2;
    uint16_t len = 0;
    char value[10];
    uint32_t ret = 0;
    
    //msg.attri
    if((name = (uint8_t *)strstr(msg.attri, param_name)))
    {
        name += strlen(param_name) + 1;
        pos2 = (uint8_t*)strstr((char*)name, "&");
        if(!pos2)
        {
            pos2 = name + strlen((char*)name);
        }
        len = pos2 - name;
        
        if(len)
        {
            strncpy(value, (char*)name, len);
            ret = atoi(value);
        }
    }
    return ret;
}


