/* FsHandler.cpp */
#include "mbed.h"
#include "FsHandler.h"
//#define DEBUG
#include "hl_debug.h"

#define Do3  131 //C octave3
#define Do3s 139 //C#
#define Re3  147 //D
#define Re3s 156//D#
#define Mi3  165 //E
#define Fa3  175 //F
#define Fa3s 185 //F#
#define So3  196 //G
#define So3s 208 //G#
#define La3  220 //A
#define La3s 233 //A#
#define Ti3  247 //B
#define Do4  262 //C octave4
#define Do4s 277 //C#
#define Re4  294 //D
#define Re4s 311//D#
#define Mi4  330 //E
#define Fa4  349 //F
#define Fa4s 370 //F#
#define So4  392 //G
#define So4s 415 //G#
#define La4  440 //A
#define La4s 466 //A#
#define Ti4  494 //B
#define Do5  523 //C octave5
#define Do5s 554 //C#
#define Re5  587 //D
#define Re5s 622//D#
#define Mi5  659 //E
#define Fa5  699 //F
#define Fa5s 740 //F#
#define So5  784 //G
#define So5s 831 //G#
#define La5  880 //A
#define La5s 932 //A#
#define Ti5  988 //B

PwmOut Buzzer(D3);

float C_3 = 1000000/Do3,
       Cs_3 = 1000000/Do3s,
       D_3 = 1000000/Re3,
       Ds_3 = 1000000/Re3s,
       E_3 = 1000000/Mi3,
       F_3 = 1000000/Fa3,
       Fs_3 = 1000000/Fa3s,
       G_3 = 1000000/So3,
       Gs_3 = 1000000/So3s,
       A_3 = 1000000/La3,
       As_3 = 1000000/La3s,
       B_3 = 1000000/Ti3,
       C_4 = 1000000/Do4,
       Cs_4 = 1000000/Do4s,
       D_4 = 1000000/Re4,
       Ds_4 = 1000000/Re4s,
       E_4 = 1000000/Mi4,
       F_4 = 1000000/Fa4,
       Fs_4 = 1000000/Fa4s,
       G_4 = 1000000/So4,
       Gs_4 = 1000000/So4s,
       A_4 = 1000000/La4,
       As_4 = 1000000/La4s,
       B_4 = 1000000/Ti4,
       C_5 = 1000000/Do5,
       Cs_5 = 1000000/Do5s,
       D_5 = 1000000/Re5,
       Ds_5 = 1000000/Re5s,
       E_5 = 1000000/Mi5,
       F_5 = 1000000/Fa5,
       Fs_5 = 1000000/Fa5s,
       G_5 = 1000000/So5,
       Gs_5 = 1000000/So5s,
       A_5 = 1000000/La5,
       As_5 = 1000000/La5s,
       B_5 = 1000000/Ti5;
       
int tones[] = {E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, D_4, 0, E_4, G_4, G_4, 0, 
                             E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, E_4, D_4, C_4, 0, 0, 0};
int tones_num = 32;
       
void Tune(PwmOut name, int period);
void Auto_tunes(PwmOut name, int period);
void Stop_tunes(PwmOut name);

DigitalOut led_red(LED1);
DigitalOut led_green(LED2);
DigitalOut led_blue(LED3);

DigitalIn  din(PC_14);

static int matchstrings(const char* one, const char* two)
{
    int m = 0;
    
    for (m = 0; m < min(strlen(one), strlen(two)) ; m++) {
        if (one[m] != two[m])
            return m;
    }
    return m;
}

std::map<const char*, const char*> HTTPFsRequestHandler::m_fsMap;
 
HTTPFsRequestHandler::HTTPFsRequestHandler(const char* rootPath, const char* localPath, HTTPConnection::HTTPMessage& Msg, TCPSocketConnection& Tcp)
    : HTTPRequestHandler(Msg, Tcp)
{
    m_rootPath = rootPath;
    m_localPath = localPath;
    
    string myPath = m_rootPath + m_localPath;
    
    //  Now replace the virtual root path with a mounted device path
    std::map<const char*, const char*>::iterator it;
    const char *bestMatch = NULL;
    const char *bestMatchExchange = NULL;
    int match_ind = -1;
    for (it = m_fsMap.begin() ; it != m_fsMap.end() ; it++) {
        //  find best match (if the given logical path is containted in the root
        int s = matchstrings(myPath.c_str(), it->second);
        INFO("Matching Root %s with handler %s results in %d identical characters\n", myPath.c_str(), it->second, s);
        if ((s == strlen(it->second)) && (s > match_ind)) {
            match_ind = s;
            bestMatch = it->first;
            bestMatchExchange = it->second;
        }
    }

    if (bestMatch != NULL) {
        m_rootPath = bestMatch;
        m_localPath = string(myPath).substr(strlen(bestMatchExchange));
    }
            
    handleRequest();
}

HTTPFsRequestHandler::~HTTPFsRequestHandler()
{
}

int HTTPFsRequestHandler::handleGetRequest()
{
    HTTPHeaders headers;
    int retval = 0;   //success
    uint8_t pin_state;
    
    if( std::string::npos != msg.uri.find("get_dio14.cgi") )
    {
        if(din)
            pin_state = 1;
        else 
            pin_state = 0;
        
        /*
        *len = sprintf((char *)buf, "DioCallback({\"dio_p\":\"14\",\
                                            \"dio_s\":\"%d\"\
                                            });",
                                            pin_state              // Digital io status
                                            );
        
            
        Tcp.
        */
    }
    else //read html pages
    {
        if (m_localPath.length() > 4) 
            getStandardHeaders(headers, m_localPath.substr(m_localPath.length()-4).c_str());
        else
            getStandardHeaders(headers);
        
        INFO("Handling Get Request (root = %s, local = %s).", m_rootPath.c_str(), m_localPath.c_str());
        
        std::string reqPath;
    
        //  Check if we received a directory with the local bath
        if ((m_localPath.length() == 0) || (m_localPath.substr( m_localPath.length()-1, 1) == "/")) {
            //  yes, we shall append the default page name
            m_localPath += "index.html";
        }
        
        reqPath = m_rootPath + m_localPath;
        
        INFO("Mapping \"%s\" to \"%s\"", msg.uri.c_str(), reqPath.c_str());
            
        FILE *fp = fopen(reqPath.c_str(), "r");
        if (fp != NULL) {
            char * pBuffer = NULL;
            int sz = 8192;
            while( pBuffer == NULL) {
                sz /= 2;
                pBuffer = (char*)malloc(sz);
                if (sz < 128)
                    error ("OutOfMemory");
            }
            
            //  File was found and can be returned
        
            //  first determine the size
            fseek(fp, 0, SEEK_END);
            long size = ftell(fp);
            fseek(fp, 0, SEEK_SET);
        
            startResponse(200, size);
            while(!feof(fp) && !ferror(fp)) {
                int cnt = fread(pBuffer, 1, sz , fp);
                if (cnt < 0)
                    cnt = 0;
                processResponse(cnt, pBuffer);
            }
            delete pBuffer;
            endResponse();
            fclose(fp);
        }
        else {
            retval = 404;
            ERR("Requested file was not found !");
        }
    }
    
    return retval;
}

int HTTPFsRequestHandler::handlePostRequest()
{
    int i = 0;
    int pin = 0;
    
    if( std::string::npos != msg.uri.find("set_LED.cgi") )
    {
        pin = get_http_param_value("pin");
        if(pin==0)   Tune(Buzzer, C_4);
        else if(pin==1) Tune(Buzzer, Cs_4);
        else if(pin==2) Tune(Buzzer, D_4);
        else if(pin==3) Tune(Buzzer, Ds_4);
        else if(pin==4) Tune(Buzzer, E_4);
        else if(pin==5) Tune(Buzzer, F_4);
        else if(pin==6) Tune(Buzzer, Fs_4);
        else if(pin==7) Tune(Buzzer, G_4);
        else if(pin==8) Tune(Buzzer, Gs_4);
        else if(pin==9) Tune(Buzzer, A_4);
        else if(pin==10) Tune(Buzzer, As_4);
        else if(pin==11) Tune(Buzzer, B_4);
        else if(pin==12) Tune(Buzzer, C_5);
        else if(pin==13) Tune(Buzzer, Cs_5);
        else if(pin==14) Tune(Buzzer, D_5);
        else if(pin==15) Tune(Buzzer, Ds_5);
        else if(pin==16) Tune(Buzzer, E_5);
        else if(pin==17) Tune(Buzzer, F_5);
        else if(pin==18) Tune(Buzzer, Fs_5);
        else if(pin==19) Tune(Buzzer, G_5);
        else if(pin==20) Tune(Buzzer, Gs_5);
        else if(pin==21) Tune(Buzzer, A_5);
        else if(pin==22) Tune(Buzzer, As_5);
        else if(pin==23) Tune(Buzzer, B_5);
        else
        {
            WARN("Wrong pin number");
        }   
        
        return 0;
    } 
    else if( std::string::npos != msg.uri.find("set_AUTO.cgi") )
    {
        pin = get_http_param_value("pin");
        if(pin==0)   
        {
            for(i=0; i<tones_num; i++)
            {
                Auto_tunes(Buzzer, tones[i]);
                wait_ms(124);
            }
            Stop_tunes(Buzzer);
        }
        else if(pin == 99)
        {
            Stop_tunes(Buzzer);   
        }    
        else
        {
            WARN("Wrong pin number");
        }   
        
        return 0;
    }   
    else
    {
           return 404;
    }
}

int HTTPFsRequestHandler::handlePutRequest()
{
    return 404;
}

uint32_t HTTPFsRequestHandler::get_http_param_value(char* param_name)
{
    uint8_t * name = 0;
    uint8_t * pos2;
    uint16_t len = 0;
    char value[10];
    uint32_t ret = 0;
    
    //msg.attri
    if((name = (uint8_t *)strstr(msg.attri, param_name)))
    {
        name += strlen(param_name) + 1;
        pos2 = (uint8_t*)strstr((char*)name, "&");
        if(!pos2)
        {
            pos2 = name + strlen((char*)name);
        }
        len = pos2 - name;
        
        if(len)
        {
            strncpy(value, (char*)name, len);
            ret = atoi(value);
        }
    }
    return ret;
}

/**
   * @brief     Tune Function
   * @param  name : Choose the PwmOut
                    period : this param is tune value. (C_3...B_5)
   * @retval    None
   */
void Tune(PwmOut name, int period)
{
    name.period_us(period);
    name.write(0.50f); // 50% duty cycle
    wait_ms(250); // 1/4 beat
    name.period_us(0); // Sound off
}

/**
   * @brief     Auto tunes Function
   * @param  name : Choose the PwmOut
                    period : this param is tune value. (C_3...B_5)
   * @retval    None
   */
void Auto_tunes(PwmOut name, int period)
{
    name.period_us(period);
    name.write(0.50f); // 50% duty cycle
    wait_ms(250); // 1/4 beat
}

void Stop_tunes(PwmOut name)
{
    name.period_us(0);
}
