#ifndef CONFIG_H_
#define CONFIG_H_

/*
 *  Communication Module configuration starts here
 */
//#define USE_SNIC_WIFI //Murata Type YD Wi-Fi
#define USE_WIZNET_W5500 //WIZnet W5500 Ethernet


/*
 *  SNIC configuration starts here
 */
#ifdef USE_SNIC_WIFI

    #define MBED_AP_SSID                  "TIDE867"//"tide855" 
    /** Securiry Options
    e_SEC_OPEN       = 0x00, //Open
    e_SEC_WEP        = 0x01, // WEP
    e_SEC_WPA_TKIP   = 0x02, // WPA-PSK(TKIP)
    e_SEC_WPA2_AES   = 0x04, // WPA2-PSK(AES)
    e_SEC_WPA2_MIXED = 0x06, // WPA2-PSK(TKIP/AES)
    e_SEC_WPA_AES    = 0x07  // WPA-PSK(AES) **/
    #define MBED_AP_SECURITY_TYPE         e_SEC_WPA2_AES//e_SEC_OPEN
    #define MBED_AP_SECUTIRY_KEY          "tidetide"

#endif//USE_SNIC_WIFI

// Some Ethernet Shields (ex.W5500) do NOT have MAC address. use your cell phone number instead.
// 010-1234-5678 -> {0x00, 0x10, 0x12, 0x34, 0x56, 0x78};
#define DEFAULT_MAC_ADDR {0x00, 0x10, 0x12, 0x34, 0x56, 0x78}   //MAC Address

/*
 *  GMMP configuration starts here
 */
#define THINGPLUG_GMMP_IP_ADDR      {61, 250, 21, 211}  //ThingPlug GMMP 서버 IP주소
#define THINGPLUG_GMMP_PORT_NUM     31002               //마이페이지 > 서비스 정보 수정 > 서비스 기본 정보 > TCP Listen Port
#define THINGPLUG_GMMP_SERVICE_NAME "ThingPlug"         //마이페이지 > 서비스 정보 수정 > 서비스 기본 정보 > 서비스 아이디

/*
 *  Gateway/Device configuration starts here
 */
#define THINGPLUG_GMMP_DEVICE_SERIAL_NUM            "01012345678"
#define THINGPLUG_GMMP_DEVICE_MANUFACTURER_ID       "STMicro"
#define THINGPLUG_GMMP_SUB_DEVICE_MANUFACTURER_ID   "STM32"

#endif /* CONFIG_H_ */
