/* Analog Input "Temp36" Temperature Sensor Example Program */
 
#include "mbed.h"

// Initialize a pins to perform analog input fucntions
AnalogIn   ain(A0);             // connect A0(WIZwiki-W7500) to Vout(Temp36)

int main(void)
{
    while (1)
    {
        float V = ain.read() * 3.3;             // connect Vs(Temp36) to 3.3V(WIZwiki-W7500) 
        //float V = ain.read() * 5;             // connect Vs(Temp36) to 5V(WIZwiki-W7500)
        
        float tempC = (V - 0.5) * 100;          // calculate temperature C
        float tempF = (tempC * 9 / 5) + 32.0;   // calculate temperature F
        
        printf("tempC value : %5.2f C \r\n", tempC);
        printf("tempF value : %5.2f F \r\n", tempF);
        
        wait(1.0);
    }
}









