#include "mbed.h"
#include "SDFileSystem.h"

#if defined(TARGET_WIZwiki_W7500)
#define MOSI                  PB_3
#define MISO                  PB_2
#define CLK                   PB_1
#define SEL                   PB_0
#endif

#define MAX_SIZE 100

SDFileSystem sd(MOSI, MISO, CLK, SEL, "sd"); // the pinout on the mbed Cool Components workshop board


int main() {

        char str[MAX_SIZE];
        
        mkdir("/sd/mydir", 0777);
        //"w" : {Write) - Create an empty file for output operations. If a file with the same name already exists, its contents are discarded and the file is treated as a new empty file.
        //"a+" :(append/update) -  open (or create if the file does not exist) for update at the end of the file
        
        FILE *fp = fopen("/sd/mydir/sdtest.txt", "w"); 
        
        if(fp == NULL)
        {
            error("Could not open file for write\n");
        }
        
        //fprintf(fp, "Hello fun SD Card World!");
        printf("Insert data:");
        scanf("%s",str);
        printf("\r\n");
        
        fflush(stdin);
        fprintf(fp,"%s", str);
        fclose(fp); 
        
        printf("Reading from SD card...\r\n");
        
        fp = fopen("/sd/mydir/sdtest.txt", "r");
        
        if (fp != NULL)
        {
             fgets(str,MAX_SIZE,fp);
             printf("%s", str);
             printf("\r\n");
            fclose(fp);
        } 
        else 
        {
            printf("failed!\n");
        }
        
}
