#include <stdio.h>
#include "mbed.h"
#include "WizFi250Interface.h"
#include "Servo.h"



Serial pc(USBTX, USBRX);

/* network setup */
WizFi250Interface wizfi250(P13,P14,P11,P12,P15,NC,115200);
TCPSocketServer server;
TCPSocketConnection client; 

#define SECURE WizFi250::SEC_WPA2_MIXED
#define SSID "WIZnet_Boat"
#define PASS "wiznetboat"
#define PORT 5000


/* motor setup */
Servo servo(P10);
PwmOut motor(P9);



/* direction define */
#define forward "WIZnet_boat_direction:forward"
#define back "WIZnet_boat_direction:back"
#define left "WIZnet_boat_direction:left"
#define right "WIZnet_boat_direction:right"
#define stop "WIZnet_boat_direction:stop"



/* Connection Steps */
typedef enum ConnectionStep { DISASSOCIATED = 1, ASSOCIATED, LISTENED, CONNECTED, DISCONNECTED } conStep;
conStep ConnectionStep = DISASSOCIATED;

/* functions */
int TryApUp();
int TryServerUpAndWaitClient();


int main()
{
    pc.baud(115200);
    motor.period_us(1000000/490);
    float speed = 0.0;   
    
    while(1)
    {
        char rcvBuf[1024] = {0,};
        int len = 0;
        
        switch(ConnectionStep)
        {
            case DISASSOCIATED:
                TryApUp();
                break;
                
            case ASSOCIATED:
            case LISTENED:
                TryServerUpAndWaitClient();
                break;
                
            case CONNECTED:       
            
                if( client.is_connected() == 0 )  ConnectionStep = DISCONNECTED;
                
                if( wizfi250.readable(0) > 0 )
                {
                    len = client.receive(rcvBuf, 1023);
                    if( len < 0 ) ConnectionStep = DISCONNECTED;
                    else if( len > 0)
                    {
                        if( strcmp(rcvBuf,forward) == 0 )
                        {
                            speed = speed + 0.01;   
                            printf("forward\r\n");
                        }
                        else if( strcmp(rcvBuf,back) == 0 )
                        {
                            speed = speed - 0.01;
                            printf("back\r\n");
                        }
                        else if( strcmp(rcvBuf,left) == 0 )
                        {
                            servo = servo - 0.1;
                            printf("left\r\n");
                        }
                        else if( strcmp(rcvBuf,right) == 0 )
                        {
                            servo = servo + 0.1;
                            printf("right\r\n");
                        }
                        else if( strcmp(rcvBuf,stop) == 0 )
                        { 
                            servo = 0.5;   // center
                            speed = 0;
                            printf("stop\r\n");
                        }
                        
                        if( speed < 0.50 ) speed = 0.50;
                        else if ( speed > 1.0 ) speed = 1.0;
                        printf("speed %.3f\r\n", speed);
                        motor.write(speed);
                    }
                }
                break;
            case DISCONNECTED:
                servo = 0.5;
                motor.write(0);
                ConnectionStep = LISTENED;
        }
    }
}

int TryApUp()
{
    
    if( wizfi250.isAssociated() == 1 ) return -1;
    
    printf(" AP UP\r\n");
    printf("SSID: %s\r\nPASS: %s", SSID, PASS);
    
    for(int i= 0; i<5; i++)
    {
        wizfi250.init("192.168.0.2","255.255.255.0","192.168.0.2");
        if ( wizfi250.connect(SECURE, SSID, PASS, WizFi250::WM_AP) )
            continue;
        else {
            printf("IP Address is %s\r\n", wizfi250.getIPAddress());
            if( wizfi250.isAssociated() == 1 )
            {
                ConnectionStep = ASSOCIATED;
                return 0;
            } else {
                continue;    
            }       
        }
    }
    
    printf("Fail to make AP\r\n");
    ConnectionStep = DISASSOCIATED;
    return -1;
}


int TryServerUpAndWaitClient()
{
    if( wizfi250.isAssociated() != 1 ) return -1;

    if( ConnectionStep == ASSOCIATED )
    {
        if( server.bind(PORT) < 0 )
        {
            printf("Bind fail..\r\n");
            return -1;
        }
        
        if( server.listen(1) < 0 )
        {
            printf("Listen fail..\r\n");
            return -1;
        } else {
            printf("Listen PORT: %d\r\n",PORT);    
            ConnectionStep = LISTENED;
        }
    }
    
    while(ConnectionStep == LISTENED)
    {
        if( server.accept(client) < 0 )
        {
            printf("accept fail..\r\n");
            return -1;
        }else{
            printf("Connection Success!!\r\nIP: %s\r\n", client.get_address());
            ConnectionStep = CONNECTED;
            return 0;
        }
    }
    
    return -1;
}
