#include "mbed.h"
#include "EthernetInterface.h"
#include "FsHandler.h"
#include "HTTPServer.h"
#include "SDFileSystem.h"

#define DHCP

#if defined(TARGET_WIZWIKI_W7500)||defined(TARGET_WIZWIKI_W7500P)||defined(TARGET_WIZWIKI_W7500ECO)
    //Choose one of file system.
    SDFileSystem local(SD_MOSI, SD_MISO, SD_CLK, SD_SEL, "local");//PB_3, PB_2, PB_1, PB_0
    //LocalFileSystem local("local");
#endif

#if defined(TARGET_WIZWIKI_W7500)||defined(TARGET_WIZWIKI_W7500P)||defined(TARGET_WIZWIKI_W7500ECO)
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0xff, 0xff, 0x10};
#endif

EthernetInterface eth;
HTTPServer  svr;

char ip_addr[] = "192.168.240.111";
char subnet_mask[] = "255.255.255.0";
char gateway_addr[] = "192.168.240.1";

int flag_t = 1;
int hour_r, min_r, hm_r = 2460, hm_n = 0;
double duty;

//ymd_buffer[0]~[3] : Year
//ymd_buffer[4]~[5] : Month
//ymd_buffer[6]~[7] : Day
char ymd_buffer[8];
//hms_buffer[0]~[1] : Hour
//hms_buffer[2]~[3] : Minute
//hms_buffer[4]~[5] : Second
char hms_buffer[6];

//#define DHCP //If uncomment, W7500 runs DHCP

int main()
{
    HTTPFsRequestHandler::mount_eth(&eth);
    HTTPFsRequestHandler::mount("/local/", "/");
    svr.addHandler<HTTPFsRequestHandler>("/");

#if defined(TARGET_WIZWIKI_W7500)||defined(TARGET_WIZWIKI_W7500P)||defined(TARGET_WIZWIKI_W7500ECO)
    
    #ifdef DHCP
        eth.init(mac_addr); //Use DHCP
    #else
        eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif

#else

    #ifdef DHCP
        eth.init(); //Use DHCP
    #else
        eth.init(ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif

#endif

    printf("Check Ethernet Link\r\n");
    while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }
    printf("Link up\r\n");

    eth.connect();
    
    printf("Server IP Address is %s\r\n", eth.getIPAddress());

    if (!svr.start(80, &eth)) {

        error("Server not starting !");
        exit(0);
    }

    while(1) {
        svr.poll();
        
        time_t seconds = time(NULL);
        strftime(hms_buffer, 6, "%H%M%S\n\r", localtime(&seconds));
        hm_n = atoi(hms_buffer);
        hm_n = hm_n / 100;
        
        if(hm_r == hm_n)
        {
            if(flag_t)
            {
                duty = 0.2;
                myservo = duty;
                wait(5);
                duty = 1;
                myservo = duty;
                flag_t = 0;
            }
        }
    }
}

