#include "mbed.h"
 
DigitalOut myled_R(LED_RED);     // LED_RED on WIZwiki-W7500
DigitalOut myled_B(LED_BLUE);    // LED_BLUE on WIZwiki-W7500

AnalogIn CDS(A0);                // Analog Input Pin A0
 
int main() {
    printf("Hello WizWIki-W7500!\r\n");
    printf("==============================\r\n");
    
    int CDS_data = 0;
    double CDS_vol = 0;
    
    while(1) {
        CDS_data = CDS.read()*1000;
        CDS_vol = CDS.read()*3.3;
        
        //CDS Seneor ADC Low Data
        printf("CDS Data : %3d\r\n",CDS_data);      
        //CDS Sensor Voltage data
        printf("CDS Voltage : %3.3lfV\r\n",CDS_vol);
        printf("===========================\r\n");
        wait(1.0);     
        
        //Status is Dark and BLUE LED OFF, RED LED ON
        if(CDS_data > 500){
            myled_R = 0;
            myled_B = 1;
        }
        //Status is Bright and BLUE LED ON, RED LED OFF
        else  {
            myled_R = 1;
            myled_B = 0;
        }
    }
}