/**
 ******************************************************************************
 * @project  Web Piano 
 * @author  Justin Kim
 * @version V1.0.0
 * @date    03-JUL-2015
 * @brief   Main program body
*******************************************************************************
**/
/* Includes ------------------------------------------------------------------*/
#include "mbed.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define Do3  131 //C octave3
#define Do3s 139 //C#
#define Re3  147 //D
#define Re3s 156//D#
#define Mi3  165 //E
#define Fa3  175 //F
#define Fa3s 185 //F#
#define So3  196 //G
#define So3s 208 //G#
#define La3  220 //A
#define La3s 233 //A#
#define Ti3  247 //B
#define Do4  262 //C octave4
#define Do4s 277 //C#
#define Re4  294 //D
#define Re4s 311//D#
#define Mi4  330 //E
#define Fa4  349 //F
#define Fa4s 370 //F#
#define So4  392 //G
#define So4s 415 //G#
#define La4  440 //A
#define La4s 466 //A#
#define Ti4  494 //B
#define Do5  523 //C octave5
#define Do5s 554 //C#
#define Re5  587 //D
#define Re5s 622//D#
#define Mi5  659 //E
#define Fa5  699 //F
#define Fa5s 740 //F#
#define So5  784 //G
#define So5s 831 //G#
#define La5  880 //A
#define La5s 932 //A#
#define Ti5  988 //B

/* Private variables ---------------------------------------------------------*/
PwmOut Buzzer(D3);


float  C_3 = 1000000/Do3,
       Cs_3 = 1000000/Do3s,
       D_3 = 1000000/Re3,
       Ds_3 = 1000000/Re3s,
       E_3 = 1000000/Mi3,
       F_3 = 1000000/Fa3,
       Fs_3 = 1000000/Fa3s,
       G_3 = 1000000/So3,
       Gs_3 = 1000000/So3s,
       A_3 = 1000000/La3,
       As_3 = 1000000/La3s,
       B_3 = 1000000/Ti3,
       C_4 = 1000000/Do4,
       Cs_4 = 1000000/Do4s,
       D_4 = 1000000/Re4,
       Ds_4 = 1000000/Re4s,
       E_4 = 1000000/Mi4,
       F_4 = 1000000/Fa4,
       Fs_4 = 1000000/Fa4s,
       G_4 = 1000000/So4,
       Gs_4 = 1000000/So4s,
       A_4 = 1000000/La4,
       As_4 = 1000000/La4s,
       B_4 = 1000000/Ti4,
       C_5 = 1000000/Do5,
       Cs_5 = 1000000/Do5s,
       D_5 = 1000000/Re5,
       Ds_5 = 1000000/Re5s,
       E_5 = 1000000/Mi5,
       F_5 = 1000000/Fa5,
       Fs_5 = 1000000/Fa5s,
       G_5 = 1000000/So5,
       Gs_5 = 1000000/So5s,
       A_5 = 1000000/La5,
       As_5 = 1000000/La5s,
       B_5 = 1000000/Ti5;
       
       int tones_airplane[] = {E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, D_4, 0, E_4, G_4, G_4, 0, 
                             E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, E_4, D_4, C_4, 0, 0};
       
       int tones_school[] = {D_4, D_4, E_4, E_4, D_4, D_4, B_3, 0, D_4, D_4, B_3, B_3, A_3, 0,
                             D_4, D_4, E_4, E_4, D_4, D_4, B_3, 0, D_4, B_3, A_3, B_3, G_3, 0, 0, 0, 0};
                             
       int tones_num = 31;

/* Private function prototypes -----------------------------------------------*/
void Tune(PwmOut name, int period);
void Auto_tunes(PwmOut name, int period);
void Stop_tunes(PwmOut name);
 
        
int main(void)
{
    int i;
    
    for(i=0; i<tones_num; i++)
    {
        Auto_tunes(Buzzer, tones_airplane[i]);      // User can change tones_airplane[i] -> tones_achool[i]
        Stop_tunes(Buzzer);
    }
}

/**
   * @brief  Tune Function
   * @param  name : Choose the PwmOut
             period : this param is tune value. (C_3...B_5)
   */
void Tune(PwmOut name, int period)
{
    name.period_us(period);
    name.write(0.50f);              // 50% duty cycle
    wait(1);                        // 1 beat
    name.period_us(0);              // Sound off
}

/**
   * @brief  Auto tunes Function
   * @param  name : Choose the PwmOut
             period : this param is tune value. (C_3...B_5)
   */
void Auto_tunes(PwmOut name, int period)
{
    name.period_us(period);
    name.write(0.50f);              // 50% duty cycle
    wait_ms(250);                   // 1/4 beat
}

/**
   * @brief  Stop tunes Function
   * @param  name : Choose the PwmOut
   */
void Stop_tunes(PwmOut name)
{
    name.period_us(0);
}

