#include "mbed.h"
#include "EthernetInterface.h"
#include "Adafruit_SSD1306.h"

class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PA_10,PA_9);
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);

//internal led
DigitalOut red_led(LED1,1);
DigitalOut blue_led(LED3,1);

int main()
{
    int phy_link;
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x09}; 
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    
    eth.connect();
    
    //phy link
     do{
        phy_link = eth.ethernet_link();
        printf("...");
        wait(2);
     }while(!phy_link);
     printf("IP Address is %s\r\n\r\n", eth.getIPAddress());

    char buffer[1024];
    int ret;

    //BUS "GET /ws/rest/busarrivalservice?serviceKey=??&routeId=??&stationId=?? \n\n"
    char http_cmd[] = "GET /ws/rest/busarrivalservice?serviceKey=1234567890&routeId=234000878&stationId=206000082 \n\n"; // 8100

    while(1)
    {
        //TCP socket connect 
        TCPSocketConnection sock;
        sock.connect("openapi.gbis.go.kr", 80);
    
        sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
        while (true)
        {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            
            if (ret <= 0)
                printf("fail\r\n");
                //break;
            else{
                buffer[ret] = '\0';
                printf("Received %d chars from server: %s\r\n", ret, buffer);
                break;
            }
        }
    printf("\r\n\r\n");
    

    // parsing data 
    char *date;
    char *bus_1st;
    char *bus_2nd;
    
    char current_date[11] = {0};
    char arrive_bus1[2] = {0};
    char arrive_bus2[2] = {0};

    date = strstr(buffer, "<queryTime>");
    for(int i=0;i<10;i++){
        current_date[i] = date[i+11];
    }
        
    bus_1st = strstr(buffer, "<predictTime1>");
    for(int i=0; i<2;i++){
        arrive_bus1[i] = bus_1st[i+14];
        if(arrive_bus1[i] == '<'){
           arrive_bus1[i] = 0;
           break;
        }
    }
    
    bus_2nd = strstr(buffer, "<predictTime2>");
    for(int i=0; i<2;i++){
        arrive_bus2[i] = bus_2nd[i+14];
        if(arrive_bus2[i] == '<'){
           arrive_bus2[i] = 0;
           break;
        }
    }
    
    printf("current date :  %s\r\n",  current_date);
    printf("arrival bus1 :  %s\r\n",  arrive_bus1);
    printf("arrival bus2 :  %s\r\n",  arrive_bus2);
      
      
    // OLED Display
    gOled.begin();
    gOled.clearDisplay();
    
    gOled.printf("%s\n\n", current_date);
    gOled.printf("No.8100\n\n");
    gOled.printf("You have %s mins\n\n", arrive_bus1);
    gOled.printf("Next Bus %s mins\n", arrive_bus2);
    gOled.display();
    gOled.setTextCursor(0,0);
    
    wait(12);
   };

}