/* Analog Input Example Program */
 
#include "mbed.h"

DigitalOut myled_R(LED_RED);

AnalogIn ain(A0);     


int main(void)
{   
    int ain_val = 0;
    
    while (1) {
        
        ain_val = ain.read()*1000;
            
        // Compare between 'Specific value' and 'Analog Input value'
        if(ain_val > 500)  
        {
            myled_R = 1;      // Red LED OFF
        }
        else    
        {
            myled_R = 0;      // Red LED ON
        }
        
        // output the voltage and analog values
        printf("======================\r\n");
        printf("voltage value : %3.3f\r\n", ain.read()*3.3f);   // voltage 0.0V ~ 3.3V
        printf("analog value : %3.3f\r\n", ain.read());         // analog value 0.0 ~ 1.0
        printf("analog value x1000 : %d\r\n",ain_val);          // analog value 0 ~ 1000
        wait(1.0);
    }
}









