/****************************************************************************/
/*  nRF24L1 module library                                                  */
/****************************************************************************/
/*  LEnsE / Julien VILLEMEJANE       /   Institut d'Optique Graduate School */
/****************************************************************************/
/*  Library - nRF24.h file                                                  */
/****************************************************************************/
/*  Tested on Nucleo-L476RG / 4th nov 2021                                  */
/****************************************************************************/

#ifndef     NRF24_H_INCLUDED
#define     NRF24_H_INCLUDED

#include    "mbed.h"
#include    "MOD24_NRF.h"
#define     TRANSFER_SIZE   8

/* Entrées - Sorties */
extern      nRF24L01P       nRF24_mod;
// Debugage
extern      Serial      debug_pc;
extern      InterruptIn bp_int;

// Transmission nrF24
extern  char    k;
extern  char    dataToSend[TRANSFER_SIZE];
extern  char    dataReceived[TRANSFER_SIZE];
extern  char    rxDataCnt;

// Fonction d'initialisation du module BT nRF24L01
void initNRF24();
// Fonction de test du module BT nRF24L01
void testNRF24(void);



#endif